<?php
/**
 * Jamroom Analytics SSE Event function
 * @copyright 2003 - 2022 by The Jamroom Network
 * @author Brian Johnson - brian@jamroom.net
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Users Online Count (current + max)
 * @return array
 */
function jrAnalytics_event_user_daily_active_data($_post, $_user, $_conf)
{
    $key = 'dashboard_user_daily_active';
    if (!$_cn = jrCore_get_local_cache_key($key)) {
        $_cn = array(
            'dau' => 1,
            'new' => 0
        );
        $now = date('Ymd');
        $_st = jrCore_get_all_stat_values('jrUser', array('ds_counts', 'active_users'), array('created', 'daily'), $now, $now);
        if (!empty($_st[0])) {
            foreach ($_st as $s) {
                if ($s['stat_index'] == 'created') {
                    $_cn['new'] = intval($s['stat_value']);
                }
                elseif ($s['stat_index'] == 'daily') {
                    $_cn['dau'] = intval($s['stat_value']);
                }
            }
        }
        $_cn['dau'] = $_cn['dau'];
        $_cn['new'] = $_cn['new'];
        jrCore_set_local_cache_key($key, $_cn, 30);
    }
    return array(
        'dau' => $_cn['dau'],
        'new' => $_cn['new']
    );
}