<?php
/**
 * Jamroom Analytics SSE Event function
 * @copyright 2003 - 2022 by The Jamroom Network
 * @author Brian Johnson - brian@jamroom.net
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Users Online Count (current + max)
 * @return string
 */
function jrAnalytics_event_user_online_info_data($_post, $_user, $_conf)
{
    $cache_key = 'dashboard_user_online_info';
    if (!$_ct = jrCore_is_cached('jrAnalytics', $cache_key, false, false, true, false)) {

        $dat             = array();
        $dat[1]['title'] = '&nbsp;';
        $dat[1]['width'] = '3%';
        $dat[2]['title'] = 'User';
        $dat[2]['width'] = '32%';
        $dat[3]['title'] = 'Location';
        $dat[3]['width'] = '55%';
        $dat[4]['title'] = 'Updated';
        $dat[4]['width'] = '10%';
        jrCore_page_table_header($dat);

        $_ct = array(
            'now'   => 0,
            'cnt'   => 0,
            'max'   => 0,
            'bot'   => 0,
            'vis'   => 0,
            'tech'  => '',
            '_cty'  => array(),
            '_tech' => array()
        );
        $_bt = array();
        $_vs = array();
        if ($_us = jrUser_session_online_user_info()) {

            // Our viewing user is ALWAYS active
            if (!empty($_us["{$_user['_user_id']}"])) {
                $_us["{$_user['_user_id']}"]['session_updated']     = (time() - 10);
                $_us["{$_user['_user_id']}"]['session_user_action'] = '/' . jrCore_get_module_url('jrCore') . "/dashboard/{$_post['module_url']}/overview";
            }

            uasort($_us, function ($a, $b) {
                return ($a['session_updated'] > $b['session_updated']) ? -1 : 1;
            });

            $idx = 1;
            $tot = 0;
            $act = 0;
            $sec = (time() - 60);
            $_ic = array();
            foreach ($_us as $uk => $u) {

                // [session_updated] => 1649611355
                // [session_user_id] => 1
                // [session_user_name] => brian
                // [session_user_group] => master
                // [session_profile_id] => 1
                // [session_quota_id] => 5
                // [session_user_ip] => 127.0.0.1
                // [session_user_action] => /core/dashboard/al/overview

                // Is this is a bot?  We'll handle it down below
                if (strpos(' ' . $u['session_user_name'], 'bot:')) {
                    if (!isset($_bt["{$u['session_user_name']}"])) {
                        $_bt["{$u['session_user_name']}"] = $u;
                    }
                    else {
                        // Already seen this bot - continue
                        unset($_us[$uk]);
                        continue;
                    }
                }
                else {
                    if ($u['session_updated'] >= $sec && !empty($u['session_user_name'])) {
                        $act++;
                    }
                }

                // @note: since our combined active + bots + visitors does not exceed 35 on view, no need
                // to get IP info data for active + bots + visitors that we will not see
                if (!empty($u['session_user_ip']) && $tot <= 35) {
                    // Have we already figured out the location for this IP?
                    if (isset($_ic["{$u['session_user_ip']}"])) {
                        // Yes...
                        $u['session_location'] = $_ic["{$u['session_user_ip']}"];
                    }
                    else {
                        // No - figure out location
                        if (jrCore_checktype($u['session_user_ip'], 'private_ip_address')) {
                            $u['session_location'] = 'LAN: ' . $u['session_user_ip'];
                        }
                        else {
                            if (function_exists('jrGeo_location') && $_ip = jrGeo_location($u['session_user_ip'], true)) {
                                // We can get via Geo Location
                                // [country_code] => US
                                // [country_name] => United States
                                // [region] => WA
                                // [city] => Seattle
                                // [postal_code] => 98127
                                // [latitude] => 47.6062
                                // [longitude] => -122.3321
                                // [continent_code] => NA
                                if (!empty($_ip['country_code'])) {
                                    $code = strtoupper($_ip['country_code']);
                                    if (!isset($_ct['_cty'][$code])) {
                                        $_ct['_cty'][$code] = 0;
                                    }
                                    $_ct['_cty'][$code]++;
                                }
                                $u['session_location'] = jrAnalytics_get_formatted_geo_location($_ip);
                            }
                            else {
                                $u['session_location'] = $u['session_user_ip'];
                            }
                        }
                        $_ic["{$u['session_user_ip']}"] = $u['session_location'];
                    }
                }
                $tot++;

                // If this is a BOT we handle down below
                if (strpos(' ' . $u['session_user_name'], 'bot:')) {
                    $_ct['bot']++;
                    continue;
                }

                // Tech: OS / Browser
                $key = 'Unknown / Unknown';
                if (!empty($u['session_user_agent'])) {
                    if (!$_ua = jrMailer_get_browser_info($u['session_user_agent'])) {
                        $_ua = array();
                    }
                    $_ua = jrCore_trigger_event('jrAnalytics', 'session_agent_info', $_ua, $u);
                    if (is_array($_ua)) {
                        $pt1 = (!empty($_ua['platform'])) ? $_ua['platform'] : 'Unknown';
                        $pt2 = (!empty($_ua['browser'])) ? $_ua['browser'] : 'Unknown';
                        $key = "{$pt1} / {$pt2}";
                    }
                }
                if (!isset($_ct['_tech'][$key])) {
                    $_ct['_tech'][$key] = 0;
                }
                $_ct['_tech'][$key]++;

                // Is this a visitor?
                if (empty($u['session_user_name'])) {
                    // Yes - this is a visitor - we will handle down below
                    $_vs[] = $u;
                    $_ct['vis']++;
                    continue;
                }

                // Only show most recent 15 but count all
                if ($idx <= 15) {
                    $dat             = array();
                    $dat[1]['title'] = $idx;
                    $dat[1]['class'] = 'center';
                    $user_name       = $u['session_user_name'];
                    if (strpos($u['session_user_ip'], 'internal')) {
                        $user_name = 'internal';
                    }
                    $dat[2]['title'] = jrCore_strip_non_utf8($user_name);

                    $_flags = array();
                    if (!empty($u['session_location'])) {
                        $_flags[] = $u['session_location'];
                    }
                    if ($user_name == 'internal') {
                        $_flags[] = 'Private IP';
                    }
                    if (!empty($_flags)) {
                        $dat[2]['title'] .= '<span class="al-user-os">' . jrCore_strip_non_utf8(implode(', ', $_flags)) . '</span>';
                    }
                    else {
                        $dat[2]['title'] .= '<span class="al-user-os">Unknown</span>';
                    }
                    $dat[2]['class'] = 'word-break" style="position:relative;cursor:pointer" title="' . jrCore_escape_js_string(jrAnalytics_get_formatted_session_info($u));
                    if (!strpos($u['session_user_ip'], 'internal')) {
                        $uid             = (jrCore_checktype($u['session_user_id'], 'number_nz')) ? intval($u['session_user_id']) : 0;
                        $js              = "jrAnalytics_load_user_info({$uid},'{$u['session_user_ip']}')";
                        $dat[2]['class'] .= '" onclick="' . $js;
                    }
                    $u['session_user_action'] = jrCore_strip_non_utf8($u['session_user_action']);
                    if (strlen($u['session_user_action']) > 50) {
                        $dat[3]['title'] = "<span title=\"{$u['session_user_action']}\">" . substr($u['session_user_action'], 0, 47) . '...</span>';
                    }
                    else {
                        $dat[3]['title'] = $u['session_user_action'];
                    }
                    $dat[3]['class'] = 'word-break';
                    $dat[4]['title'] = date('h:i:s', $u['session_updated']);
                    $dat[4]['class'] = 'center';
                    jrCore_page_table_row($dat, null, $u);
                }
                $idx++;
            }

            // TOTAL count of ALL SESSIONS
            $_ct['cnt'] = count($_us);

            // Max cannot be a cache key!
            $now = jrCore_format_time(time(), true, '%Y%m%d');
            $max = jrCore_get_temp_value('jrAnalytics', "max_online_{$now}");
            if (!$max || $_ct['cnt'] > $max) {
                jrCore_set_temp_value('jrAnalytics', "max_online_{$now}", $_ct['cnt']);
                $max = $_ct['cnt'];
            }
            $_ct['now'] = ($act == 0) ? 1 : $act;
            $_ct['max'] = $max;
        }
        jrCore_page_table_footer();
        jrCore_page_set_no_header_or_footer();
        $_ct['html'] = str_replace("\n", '', jrCore_page_display(true));

        // Bots / Crawlers
        $dat             = array();
        $dat[1]['title'] = '&nbsp;';
        $dat[1]['width'] = '3%';
        $dat[2]['title'] = 'Bot / Crawler';
        $dat[2]['width'] = '32%';
        $dat[3]['title'] = 'Location';
        $dat[3]['width'] = '55%';
        $dat[4]['title'] = 'Updated';
        $dat[4]['width'] = '10%';
        jrCore_page_table_header($dat);

        if (!empty($_bt)) {
            $idx = 1;
            $_dn = array();
            foreach ($_bt as $u) {
                $dat             = array();
                $dat[1]['title'] = $idx;
                $dat[1]['class'] = 'center';
                $user_name       = (!empty($u['session_user_name'])) ? $u['session_user_name'] : 'visitor';
                if (strpos($u['session_user_ip'], 'internal')) {
                    $user_name = 'Internal';
                }
                $user_name = str_replace('bot: ', '', $user_name);
                if (isset($_dn[$user_name])) {
                    continue;
                }
                $_dn[$user_name] = 1;
                $dat[2]['title'] = $user_name;

                $_flags = array();
                if ($user_name == 'Internal') {
                    $_flags[] = 'LAN: ' . $u['session_user_ip'];
                }
                elseif (!empty($_ic["{$u['session_user_ip']}"])) {
                    $_flags[] = $_ic["{$u['session_user_ip']}"];
                }
                if (!empty($_flags)) {
                    $dat[2]['title'] .= '<span class="al-user-os">' . implode(', ', $_flags) . '</span>';
                }
                else {
                    $dat[2]['title'] .= '<span class="al-user-os">Unknown</span>';
                }
                $dat[2]['class'] = 'word-break" style="position:relative;cursor:pointer" title="' . jrCore_escape_js_string(jrAnalytics_get_formatted_session_info($u));
                if (!strpos($u['session_user_ip'], 'internal')) {
                    $js              = "jrAnalytics_load_user_info(0,'{$u['session_user_ip']}')";
                    $dat[2]['class'] .= '" onclick="' . $js;
                }
                if (strlen($u['session_user_action']) > 50) {
                    $dat[3]['title'] = "<span title=\"{$u['session_user_action']}\">" . substr($u['session_user_action'], 0, 47) . '...</span>';
                }
                else {
                    $dat[3]['title'] = $u['session_user_action'];
                }
                $dat[3]['class'] = 'word-break';
                $dat[4]['title'] = date('h:i:s', $u['session_updated']);
                $dat[4]['class'] = 'center';
                jrCore_page_table_row($dat, null, $u);
                $idx++;
                if ($idx > 10) {
                    break;
                }
            }
        }
        else {
            $dat             = array();
            $dat[1]['title'] = 'No bots or crawlers online';
            $dat[1]['class'] = 'p10 center';
            jrCore_page_table_row($dat);
        }

        jrCore_page_set_no_header_or_footer();
        $_ct['bots'] = str_replace("\n", '', jrCore_page_display(true));

        // Visitors
        $dat[1]['title'] = '&nbsp;';
        $dat[1]['width'] = '3%';
        $dat[2]['title'] = 'User';
        $dat[2]['width'] = '32%';
        $dat[3]['title'] = 'Location';
        $dat[3]['width'] = '55%';
        $dat[4]['title'] = 'Updated';
        $dat[4]['width'] = '10%';
        jrCore_page_table_header($dat);

        if (!empty($_vs)) {
            $idx = 1;
            foreach ($_vs as $u) {
                $dat             = array();
                $dat[1]['title'] = $idx;
                $dat[1]['class'] = 'center';
                $user_name       = 'Visitor';
                if (strpos($u['session_user_ip'], 'internal')) {
                    $user_name = 'Internal';
                }
                $dat[2]['title'] = $user_name;

                $_flags = array();
                if ($user_name == 'Internal') {
                    $_flags[] = 'LAN: ' . $u['session_user_ip'];
                }
                elseif (!empty($_ic["{$u['session_user_ip']}"])) {
                    $_flags[] = $_ic["{$u['session_user_ip']}"];
                }
                if (!empty($_flags)) {
                    $dat[2]['title'] .= '<span class="al-user-os">' . implode(', ', $_flags) . '</span>';
                }
                else {
                    $dat[2]['title'] .= '<span class="al-user-os">Unknown</span>';
                }
                $dat[2]['class'] = 'word-break" style="position:relative;cursor:pointer" title="' . jrCore_escape_js_string(jrAnalytics_get_formatted_session_info($u));
                if (!strpos($u['session_user_ip'], 'internal')) {
                    $js              = "jrAnalytics_load_user_info(0,'{$u['session_user_ip']}')";
                    $dat[2]['class'] .= '" onclick="' . $js;
                }
                if (strlen($u['session_user_action']) > 50) {
                    $dat[3]['title'] = "<span title=\"{$u['session_user_action']}\">" . substr($u['session_user_action'], 0, 47) . '...</span>';
                }
                else {
                    $dat[3]['title'] = $u['session_user_action'];
                }
                $dat[3]['class'] = 'word-break';
                $dat[4]['title'] = date('h:i:s', $u['session_updated']);
                $dat[4]['class'] = 'center';
                jrCore_page_table_row($dat, null, $u);
                $idx++;
                if ($idx > 10) {
                    break;
                }
            }
        }
        else {
            $dat             = array();
            $dat[1]['title'] = 'No Visitors online';
            $dat[1]['class'] = 'p10 center';
            jrCore_page_table_row($dat);
        }

        jrCore_page_set_no_header_or_footer();
        $_ct['visitors'] = str_replace("\n", '', jrCore_page_display(true));

        // Tech
        if (!empty($_ct['_tech'])) {

            arsort($_ct['_tech'], SORT_NUMERIC);

            $dat             = array();
            $dat[1]['title'] = '&nbsp;';
            $dat[1]['width'] = '3%';
            $dat[2]['title'] = 'OS / Browser';
            $dat[2]['width'] = '87%';
            $dat[3]['title'] = 'Users';
            $dat[3]['width'] = '10%';
            jrCore_page_table_header($dat);

            $idx = 1;
            foreach ($_ct['_tech'] as $os => $count) {
                $dat             = array();
                $dat[1]['title'] = $idx;
                $dat[1]['class'] = 'center';
                $dat[2]['title'] = $os;
                $dat[3]['title'] = jrCore_number_format($count);
                $dat[3]['class'] = 'center';
                jrCore_page_table_row($dat);
                $idx++;
                if ($idx > 15) {
                    break;
                }
            }
            jrCore_page_set_no_header_or_footer();
            $_ct['tech'] = str_replace("\n", '', jrCore_page_display(true));
        }
        jrCore_add_to_cache('jrAnalytics', $cache_key, $_ct, 10, 0, false, false, false);
    }
    return $_ct;
}