<?php
 /**
 * Jamroom Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2003 - 2023 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Daily Referrers
 * @param $module string Module
 * @param $name string Name of Graph to create
 * @param $_args array Passed in Parameters
 * @return array
 */
function jrAnalytics_graph_daily_referrers($module, $name, $_args)
{
    global $_post;
    $dys = (int) $_args['days'];
    $old = (time() - ($dys * 86400));
    $old = jrCore_format_time($old, false, '%Y%m%d');
    $dom = false;
    $ttl = 'Total Daily Referrers';
    if (!empty($_post['domain'])) {
        $dom = $_post['domain'];
        $ttl = $dom;
    }
    $_rt = jrCore_get_graph_stat_values('jrAnalytics', 'ref', $dom, $old);
    return array(
        '_sets' => array(
            0 => array(
                'label'       => $ttl,
                'date_format' => '%m/%d/%Y',
                'minTickSize' => "[1, 'day']",
                'type'        => 'line',
                'pointRadius' => 3,
                '_data'       => $_rt
            )
        )
    );
}

/**
 * Analytics Dashboard Overview
 * @param $_post array Post
 * @param $_user array Active User
 * @param $_conf array Global Config
 * @return string
 */
function jrAnalytics_dashboard_overview($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_admin_only();
    // jrAnalytics_dashboard_tabs('realtime');
    // $button = jrCore_page_button('new-tag', 'New Tracking Tag', 'jrAnalytics_create_tag()');
    if (jrUser_is_master()) {
        jrCore_page_banner('Realtime Overview', '<span id="al-updated" class="al-header-info"></span> &bull; <span id="al-max-memory" class="al-header-info"></span>');
    }
    else {
        jrCore_page_banner('Realtime Overview', '<span id="al-updated" class="al-header-info"></span>');
    }
    jrCore_get_form_notice();

    $dat             = array();
    $murl            = jrCore_get_module_url('jrUser');
    $aurl            = jrCore_get_module_url('jrAnalytics');
    $dat[0]['title'] = 'Active (1m)';
    $dat[0]['width'] = '14.29%';
    $dat[1]['title'] = 'Active (15m)';
    $dat[1]['width'] = '14.29%';
    $dat[2]['title'] = 'Max Active (15m)';
    $dat[2]['width'] = '14.29%';
    $dat[3]['title'] = 'Visitors (15m)';
    $dat[3]['width'] = '14.29%';
    $dat[4]['title'] = "<div class=\"bignum_stat_cell\">Daily Active<div class=\"bignum_stat\"><a onclick=\"jrGraph_modal_graph('#al-graph-modal','{$murl}','daily_active_users');return false\">" . jrCore_get_icon_html('stats', 16) . '</a></div></div>';
    $dat[4]['width'] = '14.29%;position:relative';
    $dat[5]['title'] = "<div class=\"bignum_stat_cell\">New Accounts<div class=\"bignum_stat\"><a onclick=\"jrGraph_modal_graph('#al-graph-modal','{$murl}','daily_new_users');return false\">" . jrCore_get_icon_html('stats', 16) . '</a></div></div>';
    $dat[5]['width'] = '14.29%;position:relative';
    $dat[6]['title'] = "<div class=\"bignum_stat_cell\">Referrals<div class=\"bignum_stat\"><a onclick=\"jrGraph_modal_graph('#al-graph-modal','{$aurl}','daily_referrers');return false\">" . jrCore_get_icon_html('stats', 16) . '</a></div></div>';
    $dat[6]['width'] = '14.29%';
    jrCore_page_table_header($dat);

    $dat             = array();
    $dat[0]['title'] = '<div id="al-now-users">0</div>';
    $dat[0]['class'] = 'bignum al-bignum bignum1';
    $dat[1]['title'] = '<div id="al-active-users">0</div>';
    $dat[1]['class'] = 'bignum al-bignum bignum2';
    $dat[2]['title'] = '<div id="al-max-users">0</div>';
    $dat[2]['class'] = 'bignum al-bignum bignum3';
    $dat[3]['title'] = '<div id="al-visitor-users">0</div>';
    $dat[3]['class'] = 'bignum al-bignum bigsystem-inf';
    $dat[4]['title'] = '<div id="al-dau-users">0</div>';
    $dat[4]['class'] = 'bignum al-bignum bignum4';
    $dat[5]['title'] = '<div id="al-new-users">0</div>';
    $dat[5]['class'] = 'bignum al-bignum bignum5';
    $dat[6]['title'] = '<div id="al-total-referrals">0</div>';
    $dat[6]['class'] = 'bignum al-bignum bigsystem-inf';
    jrCore_page_table_row($dat);
    jrCore_page_table_footer();

    $htm = jrCore_parse_template('overview.tpl', $_post, 'jrAnalytics');
    jrCore_page_custom($htm);

    $_js = array("jrAnalytics_init_sse_event_listener('user_daily_active,user_online_info,user_referral_info')");
    jrCore_create_page_element('javascript_ready_function', $_js);

    $_js = array('source' => 'https://www.gstatic.com/charts/loader.js');
    jrCore_create_page_element('javascript_href', $_js);

    return 'Analytics - Realtime Overview';  // return page title
}

/**
 * Analytics Dashboard - Visitors
 * @param $_post array Post
 * @param $_user array Active User
 * @param $_conf array Global Config
 * @return string
 */
function jrAnalytics_dashboard_visitors($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_admin_only();
    jrAnalytics_dashboard_tabs('visitors');
    jrCore_page_banner('Visitors', '<span id="al-updated" class="al-header-info"></span>');
    jrCore_get_form_notice();
    return 'Analytics - Visitors';  // return page title
}

/**
 * Dashboard tabs
 * @param string $active Active tab
 * @return true
 */
function jrAnalytics_dashboard_tabs($active)
{
    global $_post;
    $url                      = jrCore_get_module_url('jrAnalytics');
    $_tabs                    = array(
        'realtime' => array(
            'label' => 'Realtime',
            'url'   => jrCore_get_base_url() . "/{$_post['module_url']}/dashboard/{$url}/overview"
        ),
        'visitors' => array(
            'label' => 'Visitors',
            'url'   => jrCore_get_base_url() . "/{$_post['module_url']}/dashboard/{$url}/visitors"
        )
    );
    $_tabs[$active]['active'] = true;
    jrCore_page_tab_bar($_tabs);
    return true;
}
