<?php
 /**
 * Jamroom Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2003 - 2023 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Add Analytics to Dashboard
 * @param $_data array incoming data array
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return array
 */
function jrAnalytics_dashboard_tabs_listener($_data, $_user, $_conf, $_args, $event)
{
    global $_post;
    $url         = jrCore_get_module_url('jrAnalytics');
    $_data[$url] = array(
        'label' => 'Analytics',
        'url'   => jrCore_get_base_url() . "/{$_post['module_url']}/dashboard/{$url}/overview"
    );
    return $_data;
}

/**
 * Watch for referral codes
 * @param $_data array incoming data array
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return array
 */
function jrAnalytics_process_init_listener($_data, $_user, $_conf, $_args, $event)
{
    if (jrCore_is_view_request()) {
        // [_rc] = <8 digit code>
        if (!empty($_REQUEST['_rc']) && strlen($_REQUEST['_rc']) === 8) {
            jrCore_create_stat_entry('jrAnalytics', 'ref', $_REQUEST['_rc']);
        }
        if ($domain = jrAnalytics_get_clean_referrer()) {
            jrCore_create_stat_entry('jrAnalytics', 'ref', $domain);
        }
    }
    return $_data;
}

/**
 * Save View Stats
 * @note client has disconnected at this point
 * @param array $_data incoming data array
 * @param array $_user current user info
 * @param array $_conf Global config
 * @param array $_args additional info about the module
 * @param string $event Event Trigger name
 * @return array
 */
function jrAnalytics_process_done_listener($_data, $_user, $_conf, $_args, $event)
{
    // jrAnalytics_record_view();
    return $_data;
}

/**
 * Process View Stats
 * @note client has disconnected at this point
 * @param array $_data incoming data array
 * @param array $_user current user info
 * @param array $_conf Global config
 * @param array $_args additional info about the module
 * @param string $event Event Trigger name
 * @return array
 */
function jrAnalytics_minute_maintenance_listener($_data, $_user, $_conf, $_args, $event)
{
    return $_data;
}
