<?php
 /**
 * Jamroom Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: user_info
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAnalytics_user_info($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    jrUser_admin_only();
    if (!empty($_post['user_id'])) {
        $uid = (int) $_post['user_id'];
        if (!$_us = jrCore_db_get_item('jrUser', $uid)) {
            jrCore_notice_page('error', 'invalid user_id - data not found');
        }
    }
    else {
        $_us = array(
            '_user_id'    => 0,
            '_profile_id' => 0
        );
    }
    $_rp = array(
        'user'   => $_us,
        'ip'     => $_post['user_ip'],
        'ipinfo' => (function_exists('jrGeo_location')) ? jrGeo_location($_post['user_ip']) : ''
    );

    $_rp['ipinfo']['location'] = jrAnalytics_get_formatted_geo_location($_rp['ipinfo']);

    $_rp  = jrCore_trigger_event('jrAnalytics', 'view_user_info', $_rp);
    $html = jrCore_parse_template('user_info.tpl', $_rp, 'jrAnalytics');
    jrCore_page_custom($html);
    jrCore_page_set_no_header_or_footer();
    $html = jrCore_page_display(true);
    jrCore_json_response(array('html' => $html), true, false);
}
