<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_album_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_create_album_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrAudio');

    // Audio files are required
    $_files = jrCore_get_uploaded_media_files('jrAudio');
    if (!$_files || !is_array($_files)) {
        jrCore_set_form_notice('error', 58);
        jrCore_form_result();
    }

    // Check for AUDIO FILES and AUDIO IMAGE
    $image = false;
    foreach ($_files as $k => $file) {
        if (strpos($file, '000_audio_image')) {
            // We uploaded an image - remove it from the files list
            $image = $file;
            unset($_files[$k]);
        }
    }
    // Image is required since we are no longer grabbing APIC for albums
    if (!$image) {
        jrCore_set_form_notice('error', 71);
        jrCore_form_result();
    }

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $num = 1;
    $iid = 0;
    $_im = false;
    $_sd = jrCore_form_get_save_data('jrAudio', 'create', $_post, false);
    foreach ($_files as $file_name) {

        // Get meta data for this file
        $field = jrCore_form_get_field_name_for_file($file_name);
        if ($_md = jrCore_form_get_uploaded_file_meta_data($field)) {
            $_rt = array_merge($_sd, $_md);
        }
        else {
            $_rt = $_sd;
        }

        // What fields from the meta data are we overriding?
        $_def = array(
            'audio_genre'          => 'no-genre',
            'audio_title'          => "audio track {$num}",
            'audio_file_publisher' => '',
            'audio_file_composer'  => '',
            'audio_file_date'      => '',
            'audio_file_track'     => 1
        );
        $_tmp = array();
        foreach ($_def as $k => $v) {
            if (!empty($_rt[$k])) {
                $_tmp[$k] = $_rt[$k];
            }
            else {
                $_tmp[$k] = $v;
            }
        }
        // Don't use our default title if there is a title from the meta data
        if ($_tmp['audio_title'] ==  $_def['audio_title'] && !empty($_rt['audio_file_title'])) {
            $_tmp['audio_title'] = $_rt['audio_file_title'];
        }
        // Add in any additional custom fields that come in
        foreach ($_rt as $k => $v) {
            if (!isset($_tmp[$k])) {
                $_tmp[$k] = $v;
            }
        }

        // If we do not have a title, use the file name
        if (empty($_tmp['audio_title'])) {
            $_tmp['audio_title'] = basename($file_name);
        }

        // Add in our SEO URL names if we get them
        foreach (array('audio_title', 'audio_album', 'audio_genre') as $k) {
            if (isset($_tmp[$k])) {
                $_tmp["{$k}_url"] = jrCore_url_string($_tmp[$k]);
            }
        }

        // Cleanup any fields that are empty...
        foreach ($_tmp as $k => $v) {
            if (strlen($v) === 0) {
                unset($_tmp[$k]);
            }
        }
        // Or that we don't want...
        if (isset($_tmp['audio_file_resolution'])) {
            unset($_tmp['audio_file_resolution']);
        }

        // We don't want to show this audio file in lists and on the site if
        // it is being converted - set our active flag to 0 if we're converting
        $_tmp['audio_active'] = 'off';

        // After the image has been assigned to the first audio file
        // it will no longer be available for the remaining files - copy
        if (is_array($_im)) {
            foreach ($_im as $k => $v) {
                if (strpos($k, 'audio_image_') === 0) {
                    $_tmp[$k] = $v;
                }
            }
        }

        // $aid will be the INSERT_ID (_item_id) of the created item
        if (!$aid = jrCore_db_create_item('jrAudio', $_tmp)) {
            jrCore_set_form_notice('error', 'unable to create new audio file in DataStore!');
            jrCore_form_result();
        }

        // Copy image over
        if (is_array($_im)) {
            $ext = $_im['audio_image_extension'];
            jrCore_copy_media_file($_user['user_active_profile_id'], "jrAudio_{$iid}_audio_image.{$ext}", "jrAudio_{$aid}_audio_image.{$ext}");
        }

        // Now that we have our DataStore Item created, link up the file with it
        // We have to tell jrCore_save_media_file the file we want to link with this item,
        // so we pass in the FULL PATH $_file_name as arg #2 to jrCore_save_media_file
        jrCore_save_media_file('jrAudio', $file_name, $_user['user_active_profile_id'], $aid);

        // Add album image
        if ($iid === 0) {
            // For the FIRST album file we can simply save the image for it
            if (jrCore_save_media_file('jrAudio', $image, $_user['user_active_profile_id'], $aid)) {
                // Grab the updated audio info - we need this to create
                // the DS keys on subsequent audio files
                $_im = jrCore_db_get_item('jrAudio', $aid, true, true);
                $iid = $aid;
            }
        }

        // Lastly, check if audio conversions are enabled.
        // If so, we need to add this item into the conversion queue
        $_queue = array(
            'item_id' => $aid,
            'field'   => 'audio_file'
        );
        jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);

        // Add the FIRST AUDIO to our actions...
        if (!isset($action_saved)) {
            // Add to Actions...
            jrCore_run_module_function('jrAction_save', 'create_album', 'jrAudio', $aid);
            $action_saved = true;
        }
        $num++;
    }
    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrCore_form_result(jrCore_get_base_url() . "/{$_user['profile_url']}/{$_post['module_url']}/albums");
}
