<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_create_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrAudio');

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_rt = jrCore_form_get_save_data('jrAudio', 'create', $_post);

    // Add in our SEO URL names
    $_to_check = array('audio_title', 'audio_album', 'audio_genre');
    foreach ($_to_check as $check) {
        if (!empty($_rt[$check])) {
            $_rt["{$check}_url"] = jrCore_url_string($_rt[$check]);
        }
    }

    // We don't want to show this audio file in lists and on the site if
    // it is being converted - set our active flag to 0 if we're converting
    $_rt['audio_active'] = 'off';

    // $aid will be the INSERT_ID (_item_id) of the created item
    if (!$aid = jrCore_db_create_item('jrAudio', $_rt)) {
        jrCore_set_form_notice('error', 18);
        jrCore_form_result();
    }

    // Save any uploaded media files
    jrCore_save_all_media_files('jrAudio', 'create', $_user['user_active_profile_id'], $aid);

    // Delete existing album ZIP file...
    jrAudio_delete_album_zip_file($_user['user_active_profile_id'], $_rt['audio_album_url']);

    // Check for uploaded audio files and convert
    // @note: We have to grab the item again here since it will now contain
    // keys for any files uploaded since jrCore_save_all_media_files has run
    if ($_rt = jrCore_db_get_item('jrAudio', $aid, true)) {

        // Go through each uploaded file and see if we need to convert
        $_audio = jrAudio_get_audio_types();
        foreach ($_rt as $k => $v) {
            if (strpos($k, '_extension') && isset($_audio[$v])) {
                // This is an uploaded media file we support
                $field  = str_replace('_extension', '', $k);
                $_queue = array(
                    'item_id' => $aid,
                    'field'   => $field
                );
                jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);
            }
        }

    }
    // Add to Actions...
    jrCore_run_module_function('jrAction_save', 'create', 'jrAudio', $aid);

    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrCore_form_result(jrCore_get_base_url() . "/{$_user['profile_url']}/{$_post['module_url']}/{$aid}/{$_rt['audio_title_url']}");
}
