<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete_album
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_delete_album($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAudio');

    // Make sure we get a good id
    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_notice_page('error', 20);
    }
    $_id = jrCore_db_get_multiple_items_by_key('jrAudio', 'audio_album_url', jrCore_url_string($_post['_1']));
    if (!$_id || !is_array($_id)) {
        jrCore_notice_page('error', 20);
    }

    // Make sure the calling user has permission to edit this item
    if (!jrUser_can_edit_item($_id[0])) {
        jrUser_not_authorized();
    }

    // Delete items that match
    $_dl = array();
    foreach ($_id as $v) {
        $_dl[] = (int) $v['_item_id'];
    }
    jrCore_db_delete_multiple_items('jrAudio', $_dl);

    // Delete existing album ZIP file...
    jrAudio_delete_album_zip_file($_user['user_active_profile_id'], $_id[0]['audio_album_url']);

    jrProfile_reset_cache($_user['user_active_profile_id'], 'jrAudio');
    jrUser_reset_cache($_user['_user_id'], 'jrAudio');
    jrCore_form_result(jrCore_get_base_url() . "/{$_user['profile_url']}/{$_post['module_url']}");
}
