<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: locate404
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_locate404($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrAudio');
    jrCore_page_banner("Validate Audio Files");

    $num = jrCore_db_number_rows('jrAudio', 'item');
    jrCore_page_note("The Validate Audio Files tool confirms that each item in the Audio Data Store has an associated audio file. <br>Items found without an associated Audio file will have the &quot;audio_404&quot; key set to <b>1</b> in the datastore.<br>It is recommended to run this during a low usage time - it can place a large load on your server while processing entries.<br><br><strong>Total Audio Files: {$num}</strong>");

    // Form init
    $url  = jrCore_get_module_url('jrAudio');
    $url  = jrCore_get_base_url() . "/{$url}/dashboard/browser/?search_string=audio_404%3A1";
    $_tmp = array(
        'submit_value'  => 'validate audio files',
        'submit_prompt' => 'Are you sure you want to validate the audio files? Please be patient - on large systems this could take some time.',
        'cancel'        => 'referrer',
        'submit_modal'  => 'update',
        'modal_width'   => 600,
        'modal_height'  => 400,
        'modal_note'    => 'Checking Audio Files',
        'modal_close'   => 'view audio items with missing files',
        'modal_onclick' => "jrCore_window_location('{$url}')"
    );
    jrCore_form_create($_tmp);
    jrCore_page_display();
}
