<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_album
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_update_album($_post, $_user, $_conf)
{
    // Must be logged in to create a new audio file
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAudio');
    jrProfile_check_disk_usage();

    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_notice_page('error', 61);
    }

    // get our first audio entry that uses this album
    $_sc = array(
        'search'         => array(
            "audio_album_url = " . jrCore_url_string($_post['_1']),
            "_profile_id = {$_user['user_active_profile_id']}"
        ),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'limit'          => 1
    );
    $_rt = jrCore_db_search_items('jrAudio', $_sc);
    if (!$_rt || !is_array($_rt['_items'])) {
        jrCore_notice_page('error', 61);
    }
    jrCore_page_banner(60);

    // Form init
    $_tmp = array(
        'submit_value' => 60,
        'cancel'       => jrCore_is_profile_referrer(),
        'values'       => $_rt['_items'][0]
    );
    jrCore_form_create($_tmp);

    // Audio Album URL
    $_tmp = array(
        'type'  => 'hidden',
        'name'  => 'existing_url',
        'value' => $_rt['_items'][0]['audio_album_url'],
    );
    jrCore_form_field_create($_tmp);

    // Audio Album
    $_tmp = array(
        'name'     => 'audio_album',
        'label'    => 31,
        'help'     => 32,
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Audio Genre
    $_tmp = array(
        'name'     => 'audio_genre',
        'label'    => 12,
        'help'     => 13,
        'type'     => 'select_and_text',
        'validate' => 'printable',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    // Audio Image
    $_tmp = array(
        'name'     => 'audio_image',
        'label'    => 16,
        'help'     => 17,
        'text'     => 39,
        'type'     => 'image',
        'value'    => $_rt['_items'][0],
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
