<?php
 /**
 * Jamroom Simple Chat module
 *
 * copyright 2021 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrChat_config()
{
    // Default Chat Room
    $_tmp = array(
        'name'     => 'default_room',
        'type'     => 'select',
        'default'  => '0',
        'options'  => jrChat_get_public_rooms(),
        'validate' => 'number_nn',
        'required' => 'on',
        'label'    => 'default public room',
        'help'     => 'If a user joins chat but has not selected a room, they will automatically join the Public room selected here.',
        'order'    => 1
    );
    jrCore_register_setting('jrChat', $_tmp);

    // Delete messages older than X days
    $_opt = array(
        0   => 'Never (default)',
        1   => 'After 1 day',
        2   => 'After 2 days',
        3   => 'After 3 days',
        4   => 'After 4 days',
        5   => 'After 5 days',
        6   => 'After 6 days',
        7   => 'After 7 days',
        10  => 'After 10 days',
        14  => 'After 2 weeks',
        21  => 'After 3 weeks',
        30  => 'After 1 month',
        60  => 'After 2 months',
        90  => 'After 3 months',
        180 => 'After 6 months',
        365 => 'After 1 year'
    );
    $_tmp = array(
        'name'     => 'history_days',
        'type'     => 'select',
        'options'  => $_opt,
        'default'  => '0',
        'validate' => 'number_nn',
        'required' => 'on',
        'label'    => 'Prune Chat Messages',
        'help'     => 'If this option is enabled, then Chat Messages that are older than the selected number of days will be deleted during the daily maintenance cycle',
        'order'    => 2
    );
    jrCore_register_setting('jrChat', $_tmp);

    return true;
}
