<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_update_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Validate all incoming posted data
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrComment');

    // Make sure we get a good _item_id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 20);
        jrCore_form_result();
    }

    // Get data
    $_rt = jrCore_db_get_item('jrComment', $_post['id']);
    if (!$_rt || !is_array($_rt)) {
        // Item does not exist....
        jrCore_set_form_notice('error', 20);
        jrCore_form_result();
    }

    // Make sure the calling user has permission to edit this item
    if (!jrComment_user_can_edit_item($_rt)) {
        jrUser_not_authorized();
    }

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_sv = jrCore_form_get_save_data('jrComment', 'update', $_post);

    // Save all updated fields to the Data Store
    jrCore_db_update_item('jrComment', $_post['id'], $_sv);

    // Save any uploaded media file
    // If this is an ADMIN user modifying a post by another user, we need to make
    // sure the profile_id is set to the proper profile_id
    if (jrUser_is_admin() || jrUser_get_profile_home_key('quota_jrComment_attachments') == 'on') {
        if (jrUser_is_admin() && $_rt['_profile_id'] != jrUser_get_profile_home_key('_profile_id')) {
            jrCore_save_all_media_files('jrComment', 'update', $_rt['_profile_id'], $_post['id'], $_rt);
        }
        else {
            jrCore_save_all_media_files('jrComment', 'update', jrUser_get_profile_home_key('_profile_id'), $_post['id'], $_rt);
        }
    }

    // Get URL we came from
    $url = jrCore_get_memory_url("comment_edit_{$_post['id']}");
    jrCore_delete_memory_url("comment_edit_{$_post['id']}");

    jrCore_form_delete_session();
    jrProfile_reset_cache($_rt['comment_profile_id'], 'jrComment');
    jrProfile_reset_cache($_rt['comment_profile_id'], $_rt['comment_module']);
    jrUser_reset_cache($_user['_user_id']);
    jrCore_form_result("{$url}#c{$_post['id']}");
}
