<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_reset_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_reset_save($_post, $_user, $_conf)
{
    global $_post;
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (!empty($_post['id']) && jrCore_checktype($_post['id'], 'md5')) {
        if ($_form = jrCore_form_get_session($_post['id'])) {
            if (isset($_form['form_user_id']) && $_form['form_user_id'] == $_user['_user_id']) {
                // Reset cancel memory URLs
                if ($_urls = jrCore_get_all_memory_urls()) {
                    foreach ($_urls as $tag => $url) {
                        if ($tag == "cancel:{$_post['id']}") {
                            jrCore_delete_memory_url($tag);
                            break;
                        }
                    }
                }
                // Did we have an UPLOAD field in this form?  If so
                // we have to reset any temp upload files
                if (!empty($_form['form_fields']) && is_array($_form['form_fields'])) {
                    foreach ($_form['form_fields'] as $f) {
                        if (isset($f['name']) && $f['name'] == 'upload_token') {
                            // Did we actually UPLOAD anything?
                            if (jrUser_get_session_key("form_session_uploads_{$_post['id']}")) {
                                // Yes we did - reset
                                $_post['upload_token'] = $f['value'];
                                break;
                            }
                        }
                    }
                }
                // Reset form session
                jrUser_delete_session_key("form_session_uploads_{$_post['id']}");
                // Cleanup any OLD form session upload session keys
                $old = (time() - 7200);
                foreach ($_SESSION as $k => $v) {
                    if (strpos($k, 'form_session_uploads_') === 0 && $v < $old) {
                        jrUser_delete_session_key($k);
                    }
                }
                jrCore_form_delete_session($_post['id']);
                jrCore_json_response(array('reset' => $_post['id']));
            }
        }
    }
    jrCore_json_response(array('reset' => 0));
}
