<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: icon_sprite
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_icon_sprite($_post, $_user, $_conf)
{
    jrUser_ignore_action();
    $skin  = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
    $width = 64;
    if (isset($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz') && $_post['_1'] < 64) {
        $width = intval($_post['_1']);
    }
    // Get the color our skin is requesting
    $color = 'white';
    if (isset($_post['_2']) && ($_post['_2'] == 'black' || strlen($_post['_2']) === 6)) {
        $color = $_post['_2'];
    }
    else {
        $_tmp = jrCore_get_registered_module_features('jrCore', 'icon_color');
        if (isset($_tmp[$skin])) {
            $color = array_keys($_tmp[$skin]);
            $color = reset($color);
        }
    }
    $dir = jrCore_get_module_cache_dir($skin);
    if (!is_file("{$dir}/sprite_{$color}_{$width}.png") || !is_file("{$dir}/sprite_{$color}_{$width}.css")) {
        jrCore_create_css_sprite($_conf['jrCore_active_skin'], $color, $width);
        $tim = time();
    }
    else {
        $tim = filemtime("{$dir}/sprite_{$color}_{$width}.png");
    }

    $exp = (time() + 86400);
    jrCore_set_custom_header('Last-Modified: ' . gmdate('D, d M Y H:i:s \G\M\T', $tim));
    jrCore_set_custom_header('Content-Disposition: inline; filename="sprite_' . $color . '_' . $width . '.png"');
    jrCore_set_custom_header('Content-Type: image/png');
    jrCore_set_custom_header('Cache-Control: must-revalidate');
    jrCore_set_custom_header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', $exp));

    $ifs = false;
    if (!empty($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
        $ifs = $_SERVER['HTTP_IF_MODIFIED_SINCE'];
    }
    elseif (function_exists('getenv')) {
        $ifs = getenv('HTTP_IF_MODIFIED_SINCE');
    }
    if ($ifs && strtotime($ifs) == $tim) {
        // We have not been modified since the browser requested the file
        jrCore_set_custom_header('HTTP/1.1 304 Not Modified');
        jrCore_send_response_and_detach();
    }
    // Fall through - send out file
    $file = jrCore_file_get_contents("{$dir}/sprite_{$color}_{$width}.png");
    jrCore_send_response_and_detach($file);
}
