<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: module_detail_features
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_module_detail_features($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('item detail features', 'features provided by modules for item detail pages');
    jrCore_get_form_notice();

    // Get all registered features
    $_tmp = jrCore_get_registered_module_features('jrCore', 'item_detail_feature');
    if (!$_tmp || !is_array($_tmp)) {
        jrCore_notice_page('notice', 'There are no modules in the system that provide Item Detail Features');
    }

    $_ord = array();
    if (isset($_conf['jrCore_detail_feature_order']) && strlen($_conf['jrCore_detail_feature_order']) > 0) {
        $_ord = array_flip(explode(',', $_conf['jrCore_detail_feature_order']));
    }
    else {
        foreach ($_tmp as $mod => $_ft) {
            foreach ($_ft as $name => $_ftr) {
                $_ord[] = "{$mod}~{$name}";
            }
        }
        jrCore_set_setting_value('jrCore', 'detail_feature_order', implode(',', $_ord));
        $_ord = array_flip($_ord);
    }

    // First get things in the right order
    $_res = array();
    foreach ($_tmp as $mod => $_ft) {
        if (jrCore_module_is_active($mod)) {
            foreach ($_ft as $nam => $_ftr) {
                $name           = "{$mod}~{$nam}";
                $_ftr['module'] = $mod;
                $_res[$name]    = $_ftr;
            }
        }
    }

    $dat             = array();
    $dat[1]['title'] = '';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'order';
    $dat[2]['width'] = '2%';
    $dat[3]['title'] = 'feature';
    $dat[3]['width'] = '25%';
    $dat[4]['title'] = 'description';
    $dat[4]['width'] = '61%';
    $dat[5]['title'] = 'template name';
    $dat[5]['width'] = '10%';
    jrCore_page_table_header($dat);

    $cnt = 0;
    // First do our items that have been ordered
    if (count($_ord) > 0) {
        foreach ($_ord as $name => $order) {
            if (!isset($_res[$name])) {
                continue;
            }
            $_ftr            = $_res[$name];
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html($_ftr['module'], 32);
            if ($cnt === 0) {
                $dat[2]['title'] = '';
            }
            else {
                $dat[2]['title'] = jrCore_page_button("idf-{$cnt}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/module_detail_feature_order/{$name}/{$cnt}')");
            }
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = $_ftr['label'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_ftr['help'];
            list(, $tpl_name) = explode('~', $name);
            $dat[5]['title'] = $tpl_name;
            $dat[5]['class'] = 'center';
            jrCore_page_table_row($dat, null, $_ftr);
            $cnt++;
            unset($_res[$name]);
        }
    }
    // Any left overs
    if (count($_res) > 0) {
        foreach ($_res as $name => $_ftr) {
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html($_ftr['module'], 32);
            if ($cnt === 0) {
                $dat[2]['title'] = '';
            }
            else {
                $dat[2]['title'] = jrCore_page_button("idf-{$cnt}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/module_detail_feature_order/{$name}/{$cnt}')");
            }
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = $_ftr['label'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_ftr['help'];
            list(, $tpl_name) = explode('~', $name);
            $dat[5]['title'] = $tpl_name;
            $dat[5]['class'] = 'center';
            jrCore_page_table_row($dat, null, $_ftr);
            $cnt++;
        }
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
