<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_image_delete_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_image_delete_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    if (empty($_post['skin']) && empty($_post['mod'])) {
        jrCore_set_form_notice('error', 'Invalid skin or module - please try again');
        jrCore_form_result();
    }
    if (empty($_post['name'])) {
        jrCore_set_form_notice('error', 'Invalid image name - please try again');
        jrCore_form_result();
    }
    if (!empty($_post['mod'])) {
        $nam = $_post['mod'];
        $tag = 'mod_';
    }
    else {
        $nam = $_post['skin'];
        $tag = '';
    }
    // Remove from custom image info
    if (!empty($_conf["jrCore_{$nam}_custom_images"])) {
        $_im = json_decode($_conf["jrCore_{$nam}_custom_images"], true);
        unset($_im["{$_post['name']}"]);
        // Update setting with new values
        if (count($_im) > 0) {
            jrCore_set_setting_value('jrCore', "{$nam}_custom_images", json_encode($_im));
        }
        else {
            jrCore_delete_setting('jrCore', "{$nam}_custom_images");
        }
        jrCore_delete_all_cache_entries('jrCore', 0);
        jrCore_delete_media_file(0, "{$tag}{$nam}_{$_post['name']}");
    }
    jrCore_set_form_notice('success', 'The custom image was successfully deleted');
    jrCore_form_result();
}
