<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: template_compare
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_template_compare($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    if (isset($_post['skin'])) {
        $cancel_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/templates/skin={$_post['skin']}";
        $t_type     = 'skin';
    }
    else {
        $cancel_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/templates";
        $t_type     = 'module';
    }

    // DATABASE TEMPLATE
    if (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {
        $tbl = jrCore_db_table_name('jrCore', 'template');
        $req = "SELECT * FROM {$tbl} WHERE template_id = '{$_post['id']}'";
        $_tp = jrCore_db_query($req, 'SINGLE');
        if (!$_tp || !is_array($_tp)) {
            jrCore_set_form_notice('error', 'Invalid template_id - please try again');
            jrCore_location($cancel_url);
        }
        $tp1 = $_tp['template_body'];
        $mod = $_tp['template_module'];
        $nam = $_tp['template_name'];
        $tag = 'custom';
    }

    // SKIN TEMPLATE
    elseif ($t_type == 'skin') {
        if (!is_file(APP_DIR . "/skins/{$_post['skin']}/{$_post['id']}")) {
            jrCore_set_form_notice('error', 'skin template file not found - please try again');
            jrCore_location($cancel_url);
        }
        $tp1 = trim(jrCore_file_get_contents(APP_DIR . "/skins/{$_post['skin']}/{$_post['id']}"));
        $mod = $_post['skin'];
        $nam = $_post['id'];
    }

    // MODULE TEMPLATE
    else {
        if (!is_file(APP_DIR . "/modules/{$_post['module']}/templates/{$_post['id']}")) {
            jrCore_set_form_notice('error', 'module template file not found - please try again');
            jrCore_location($cancel_url);
        }
        $tp1 = trim(jrCore_file_get_contents(APP_DIR . "/modules/{$_post['module']}/templates/{$_post['id']}"));
        $mod = $_post['module'];
        $nam = $_post['id'];
    }
    $omod = $mod;

    // Handle our incoming version, which can be in the following format
    // ModDir:Version:Custom-[id]
    $cst = false;
    if (isset($_post['version']) && strlen($_post['version']) > 0) {
        @list($dir, $ver, $cst) = explode(':', $_post['version']);
        $_post['version'] = $ver;
        $mod              = $dir;
    }

    // Okay - we know this user has customized this template, so we compare to the
    // version located on the file system

    if ($t_type == 'skin') {
        if (isset($_post['version']) && strlen($_post['version']) > 0) {
            if (isset($_mods[$mod])) {
                // We are comparing a skin override template to it's module counterpart
                $tnam     = str_replace("{$mod}_", '', $nam);
                $tpl_file = APP_DIR . "/modules/{$mod}-release-{$_post['version']}/templates/{$tnam}";
                if (!is_file($tpl_file)) {
                    $tpl_file = APP_DIR . "/modules/{$mod}/templates/{$tnam}";
                }
            }
            else {
                $tpl_file = APP_DIR . "/skins/{$mod}-release-{$_post['version']}/{$nam}";
                if (!is_file($tpl_file)) {
                    $tpl_file = APP_DIR . "/skins/{$mod}/{$nam}";
                }
            }
        }
        else {
            if (isset($_mods[$mod])) {
                $tnam     = str_replace("{$mod}_", '', $nam);
                $tpl_file = APP_DIR . "/skins/{$mod}/templates/{$tnam}";
            }
            else {
                $tpl_file = APP_DIR . "/skins/{$mod}/{$nam}";
            }
        }
        jrCore_start_timer('filesystem');
        $_v1 = glob(APP_DIR . "/skins/*-release-*/{$nam}");
        $_v2 = glob(APP_DIR . "/skins/*/{$nam}");
        jrCore_stop_timer('filesystem');

        // Is this a module override template?  If so, get version from module
        if (strpos($nam, '_')) {
            list($tmod, $tnam) = explode('_', $nam, 2);
            if (isset($_mods[$tmod]) && is_file(APP_DIR . "/modules/{$tmod}/templates/{$tnam}")) {
                $_v2[] = APP_DIR . "/modules/{$tmod}/templates/{$tnam}";
            }
        }
        $_vers  = array_merge($_v1, $_v2);
        $_vers  = array_unique($_vers);
        $_meta  = jrCore_skin_meta_data($mod);
        $active = $_meta['version'];
        $_met2  = jrCore_skin_meta_data($_post['skin']);
        if (!isset($tag)) {
            $tag = $_met2['version'];
        }
        $ctype = "/skin={$_post['skin']}";
    }
    else {
        if (isset($_post['version']) && strlen($_post['version']) > 0) {
            $tpl_file = APP_DIR . "/modules/{$mod}-release-{$_post['version']}/templates/{$nam}";
            if (!is_file($tpl_file)) {
                $tpl_file = APP_DIR . "/modules/{$mod}/templates/{$nam}";
            }
        }
        else {
            $tpl_file = APP_DIR . "/modules/{$mod}/templates/{$nam}";
        }

        jrCore_start_timer('filesystem');
        $_v1 = glob(APP_DIR . "/modules/*-release-*/templates/{$nam}");
        $_v2 = glob(APP_DIR . "/modules/*/templates/{$nam}");
        jrCore_stop_timer('filesystem');

        $_vers  = array_merge($_v1, $_v2);
        $_vers  = array_unique($_vers);
        $active = $_mods[$mod]['module_version'];
        if (!isset($tag)) {
            $tag = $_mods["{$_post['module']}"]['module_version'];
        }
        $ctype = '';
    }

    $tp2 = false;
    if ($cst && isset($dir)) {
        list($ver, $tid) = explode('-', $cst, 2);
        $_post['version'] = $ver;
        // get the db version
        $tbl = jrCore_db_table_name('jrCore', 'template');
        $req = "SELECT * FROM {$tbl} WHERE template_id = '{$tid}'";
        $_tp = jrCore_db_query($req, 'SINGLE');
        if ($_tp && is_array($_tp)) {
            $_rp                  = array(
                $dir                        => $omod,
                substr($dir, 2)             => substr($omod, 2),
                strtolower($dir)            => strtolower($omod),
                strtoupper($dir)            => strtoupper($omod),
                strtolower(substr($dir, 2)) => strtolower(substr($omod, 2)),
                strtoupper(substr($dir, 2)) => strtoupper(substr($omod, 2)),
            );
            $_tp['template_body'] = trim($_tp['template_body']);
            $tp2                  = strtr($_tp['template_body'], $_rp);
        }
    }
    elseif (is_file($tpl_file)) {

        if (isset($dir)) {
            $_rp = array(
                $dir                        => $_post['skin'],
                substr($dir, 2)             => substr($_post['skin'], 2),
                strtolower($dir)            => strtolower($_post['skin']),
                strtoupper($dir)            => strtoupper($_post['skin']),
                strtolower(substr($dir, 2)) => strtolower(substr($_post['skin'], 2)),
                strtoupper(substr($dir, 2)) => strtoupper(substr($_post['skin'], 2)),
            );
            $tp2 = strtr(jrCore_file_get_contents($tpl_file), $_rp);
        }
        else {
            $tp2 = trim(jrCore_file_get_contents($tpl_file));
        }
    }
    if (!$tp2) {
        jrCore_set_form_notice('error', "{$t_type} template file not found - please try again (2)");
        jrCore_location($cancel_url);
    }

    // Create jumper of previous versions if they exist
    if (is_array($_vers) && count($_vers) > 0) {

        if (isset($_post['version']) && strlen($_post['version']) > 0) {
            $sel = $_post['version'];
        }
        else {
            $sel = $active;
        }

        $selected = false;
        foreach ($_vers as $full_file) {

            // allow them to compare the file OTHER files of the same name
            if (strpos($full_file, '/skins/')) {
                $tmp = explode('-', basename(dirname($full_file)));
            }
            else {
                $tmp = explode('-', basename(dirname(dirname($full_file))));
            }
            $ver = end($tmp);
            $tmp = reset($tmp);
            $fnm = "{$tmp}/{$nam}";
            if ($t_type == 'skin' && isset($_mods[$tmp])) {
                $fnm = "{$tmp}/templates/" . str_replace("{$tmp}_", '', $nam);
            }

            if ($ver == $tmp) {
                // This is a NON release directory
                if (isset($_mods[$tmp])) {
                    $ver = $_mods[$tmp]['module_version'];
                }
                else {
                    $_sk = jrCore_skin_meta_data($tmp);
                    if ($_sk) {
                        $ver = $_sk['version'];
                    }
                    else {
                        continue;
                    }
                }
            }

            $v = "{$tmp}:{$ver}";

            if ($mod == $tmp && $ver == $sel) {
                $selected = $v;
            }
            $_option[$v] = "{$fnm} - {$ver}";
        }

        // add in any custom templates of the same name
        $skn = jrCore_get_skins();
        $skn = "'" . implode("','", array_keys($skn)) . "'";
        $tbl = jrCore_db_table_name('jrCore', 'template');
        $req = "SELECT * FROM {$tbl} WHERE template_name = '{$nam}' AND `template_module` IN ({$skn})";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt)) {
            foreach ($_rt as $_row) {
                $v = "{$_row['template_module']}:{$_row['template_name']}:custom-{$_row['template_id']}";
                if ($cst && isset($tid) && $tid == $_row['template_id']) {
                    $selected = $v;
                }
                $_option[$v] = "{$_row['template_module']}/{$_row['template_name']} - custom";
            }
        }
        // ordering
        $sub = '<select name="skin_jumper" class="form_select form_select_item_jumper" onchange="jrCore_window_location(\'' . $_conf['jrCore_base_url'] . "/{$_post['module_url']}/template_compare{$ctype}/id={$_post['id']}/version='+ $(this).val())\">\n";

        natcasesort($_option);
        if ($t_type == 'module') {
            foreach ($_option as $v => $t) {
                if ($selected == $v) {
                    $sub .= '<option value="' . $v . '" selected="selected"> ' . $t . "</option>\n";
                }
                else {
                    $sub .= '<option value="' . $v . '"> ' . $t . "</option>\n";
                }
            }
        }
        else {
            $_opt_s = array();
            $_opt_m = array();
            foreach ($_option as $v => $t) {
                list($sdir,) = explode(':', $v);
                if (isset($_mods[$sdir])) {
                    $_opt_m[$v] = $t;
                }
                else {
                    $_opt_s[$v] = $t;
                }
            }
            if (count($_opt_m) > 0) {
                $sub .= "<optgroup label=\"skins\">\n";
                foreach ($_opt_s as $v => $t) {
                    if ($selected == $v) {
                        $sub .= '<option value="' . $v . '" selected="selected"> ' . $t . "</option>\n";
                    }
                    else {
                        $sub .= '<option value="' . $v . '"> ' . $t . "</option>\n";
                    }
                }
                $sub .= "</optgroup>\n";
                $sub .= "<optgroup label=\"modules\">\n";
                foreach ($_opt_m as $v => $t) {
                    if ($selected == $v) {
                        $sub .= '<option value="' . $v . '" selected="selected"> ' . $t . "</option>\n";
                    }
                    else {
                        $sub .= '<option value="' . $v . '"> ' . $t . "</option>\n";
                    }
                }
                $sub .= "</optgroup>\n";
            }
            else {
                foreach ($_option as $v => $t) {
                    if ($selected == $v) {
                        $sub .= '<option value="' . $v . '" selected="selected"> ' . $t . "</option>\n";
                    }
                    else {
                        $sub .= '<option value="' . $v . '"> ' . $t . "</option>\n";
                    }
                }
            }
        }
        $sub .= '</select>';
    }
    else {
        $sub = $nam;
        $sel = $active;
    }

    jrCore_page_banner("template compare", $sub);

    if (isset($dir)) {
        if (isset($_mods[$dir])) {
            $ttl = "Compared To: {$dir}/templates/" . str_replace("{$dir}_", '', $nam);
        }
        else {
            $ttl = "Compared To: {$dir}/{$nam}";
        }
        jrCore_set_form_notice('success', "To help highlight changes all instances of <b>{$dir}</b> in the compare file have been changed to <b>{$_post['skin']}</b>", false);
    }
    elseif (!isset($_post['version'])) {
        $ttl = "{$omod}/{$nam}";
    }
    else {
        $ttl = $nam;
    }
    jrCore_get_form_notice();

    $ver = $_mods['jrCore']['module_version'];

    // Setup Code Mirror
    jrCore_create_page_element('css_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/lib/codemirror.css?_v={$ver}"));
    jrCore_create_page_element('css_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/addon/merge/merge.css?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/lib/codemirror.js?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/addon/diff_match_patch.js?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/addon/merge/merge.js?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/mode/htmlmixed/htmlmixed.js?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/mode/xml/xml.js?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/codemirror/mode/smarty/smarty.js?_v={$ver}"));

    // Mergely
    jrCore_create_page_element('css_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/mergely/mergely.css?_v={$ver}"));
    jrCore_create_page_element('javascript_footer_href', array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/mergely/mergely.min.js?_v={$ver}"));

    $_tmp = array(
        'submit_value'     => 'save changes',
        'cancel'           => $cancel_url,
        'onclick'          => 'jrCore_compare_get_modified_template();',
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    $html = "<div><table><tr><th class=\"diff_head\">{$omod}/{$nam} ({$tag})</th><th class=\"diff_head\">{$ttl} ({$sel})</th></tr>";
    $html .= "<tr><td colspan=\"2\">";

    $_rep = array(
        'code_left'    => json_encode($tp1),
        'code_right'   => json_encode($tp2),
        'succcess_url' => $cancel_url
    );
    if (isset($_post['skin'])) {
        $_rep['skin'] = $_post['skin'];
    }
    else {
        $_rep['module_url'] = $_post['module_url'];
    }

    if (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {
        $_rep['template_id'] = $_post['id'];
    }
    else {
        $_rep['template_name'] = $_post['id'];
    }

    $html .= jrCore_parse_template('template_compare.tpl', $_rep, 'jrCore');
    $html .= "</td></tr></table></div>";
    jrCore_page_custom($html);

    jrCore_page_display();
}
