<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCustomForm', 'browse');

    $num = jrCore_db_number_rows('jrCustomForm', 'form');
    $tbl = jrCore_db_table_name('jrCustomForm', 'form');
    $req = "SELECT * FROM {$tbl} ORDER BY form_updated DESC";
    // find how many lines we are showing
    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }
    $_rt = jrCore_db_paged_query($req, $_post['p'], 12, 'NUMERIC', $num);

    $create = jrCore_page_button('form_create', 'create new form', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/create')");
    jrCore_page_banner('custom forms', $create);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'view form';
    $dat[1]['width'] = '5%;';
    $dat[2]['title'] = 'title';
    $dat[2]['width'] = '61%;';
    $dat[3]['title'] = 'responses';
    $dat[3]['width'] = '8%;';
    $dat[4]['title'] = 'login';
    $dat[4]['width'] = '8%;';
    $dat[5]['title'] = 'unique';
    $dat[5]['width'] = '8%;';
    $dat[6]['title'] = 'fields';
    $dat[6]['width'] = '5%;';
    $dat[7]['title'] = 'settings';
    $dat[7]['width'] = '5%;';
    $dat[8]['title'] = 'delete';
    $dat[8]['width'] = '5%;';
    jrCore_page_table_header($dat);

    if (isset($_rt['_items']) && is_array($_rt['_items'])) {
        foreach ($_rt['_items'] as $k => $_form) {
            $dat             = array();
            $dat[1]['title'] = jrCore_page_button("cf-viewform-{$k}", $_form['form_name'], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/{$_form['form_name']}')");
            $dat[1]['class'] = 'center form_name_button';
            $dat[2]['title'] = $_form['form_title'];
            if (isset($_form['form_responses']) && $_form['form_responses'] > 0) {
                $dat[3]['title'] = jrCore_page_button("cf-count-{$k}", jrCore_number_format($_form['form_responses']), "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/response_browser/id={$_form['form_id']}')");
            }
            else {
                $dat[3]['title'] = '0';
            }
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_form['form_login'];
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = $_form['form_unique'];
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button("cf-fields-{$k}", 'fields', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/form_designer/m=jrCustomForm/v={$_form['form_name']}')");
            $dat[7]['title'] = jrCore_page_button("cf-settings-{$k}", 'settings', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/update/id={$_form['form_id']}')");
            $dat[8]['title'] = jrCore_page_button("cf-delete-{$k}", 'delete', "jrCore_confirm('Delete this form?','The form will be deleted along with any responses',function(){jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_save/id={$_form['form_id']}')})");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'no custom forms have been craeated yet';
        $dat[1]['class'] = 'p20 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
