<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_create_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Make sure this new form is unique
    $tbl = jrCore_db_table_name('jrCustomForm', 'form');
    $req = "SELECT * FROM {$tbl} WHERE form_name = '" . jrCore_db_escape($_post['form_name']) . "' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (isset($_rt) && is_array($_rt)) {
        jrCore_set_form_notice('error', 'There is already a form using that form name - please enter another');
        jrCore_form_field_hilight('form_name');
        jrCore_form_result();
    }
    $nam = jrCore_db_escape($_post['form_name']);
    $ttl = jrCore_db_escape($_post['form_title']);
    $msg = jrCore_db_escape($_post['form_message']);
    $req = "INSERT INTO {$tbl} (form_created,form_updated,form_name,form_title,form_message,form_unique,form_login)
            VALUES (UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),'{$nam}','{$ttl}','{$msg}','{$_post['form_unique']}','{$_post['form_login']}')";
    $fid = jrCore_db_query($req, 'INSERT_ID');
    if ($fid && jrCore_checktype($fid, 'number_nz')) {
        // Create our single default field
        $_field = array(
            'name'     => 'form_content',
            'type'     => 'textarea',
            'label'    => 'Content',
            'help'     => 'change this',
            'validate' => 'printable',
            'locked'   => 0,
            'required' => true
        );
        jrCore_verify_designer_form_field('jrCustomForm', $_post['form_name'], $_field);

        // Activate it or it won't show
        $tbl = jrCore_db_table_name('jrCore', 'form');
        $req = "UPDATE {$tbl} SET `active` = 1 WHERE `module` = 'jrCustomForm' AND `view` = '" . jrCore_db_escape($_post['form_name']) . "' AND `name` = 'form_content' LIMIT 1";
        jrCore_db_query($req);

        // Redirect to form designer
        jrCore_register_module_feature('jrCore', 'designer_form', 'jrCustomForm', $_post['form_name']);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/form_designer/m=jrCustomForm/v=" . $_post['form_name']);
    }
    jrCore_set_form_notice('error', 'An error was encountered creating the new form - please try again');
    jrCore_form_result();
}
