<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_delete_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid form id');
        jrCore_form_result();
    }
    $tbl = jrCore_db_table_name('jrCustomForm', 'form');
    $req = "SELECT * FROM {$tbl} WHERE form_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid form id');
        jrCore_form_result();
    }
    // Delete it
    $req = "DELETE FROM {$tbl} WHERE form_id = '" . jrCore_db_escape($_post['id']) . "' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {

        // Delete any form designer fields for this
        $tbl = jrCore_db_table_name('jrCore', 'form');
        $req = "DELETE FROM {$tbl} WHERE `module` = 'jrCustomForm' AND `view` = '" . jrCore_db_escape($_rt['form_name']) . "'";
        jrCore_db_query($req);

        // Delete any responses
        if ($_id = jrCore_db_get_multiple_items_by_key('jrCustomForm', 'form_name', $_rt['form_name'], true, true)) {
            jrCore_db_delete_multiple_items('jrCustomForm', $_id, true, true, true, false);
        }

        jrCore_set_form_notice('success', 'The form was successfully deleted');
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered deleting the form - please try again');
    }
    jrCore_form_result();
}
