<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: response_browser
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_response_browser($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCustomForm', 'browse');
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid form id');
        jrCore_location('referrer');
    }
    $fid = (int) $_post['id'];
    $tbl = jrCore_db_table_name('jrCustomForm', 'form');
    $req = "SELECT * FROM {$tbl} WHERE form_id = '{$fid}'";
    $_fm = jrCore_db_query($req, 'SINGLE');
    if (!$_fm || !is_array($_fm)) {
        jrCore_set_form_notice('error', 'invalid form id - data not found');
        jrCore_location('referrer');
    }

    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }

    $_sc = array(
        'search'                       => array(
            "form_name = {$_fm['form_name']}"
        ),
        'order_by'                     => array(
            '_item_id' => 'desc'
        ),
        'exclude_jrProfile_quota_keys' => true,
        'ignore_pending'               => true,
        'quota_check'                  => false,
        'no_cache'                     => true,
        'pagebreak'                    => jrCore_get_pager_rows(),
        'page'                         => $page
    );
    $_sc = jrCore_db_search_items('jrCustomForm', $_sc);

    jrCore_page_banner('&quot;' . $_fm['form_title'] . '&quot; form responses');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'user';
    $dat[1]['width'] = '10%;';
    $dat[2]['title'] = 'response';
    $dat[2]['width'] = '85%;';
    $dat[3]['title'] = 'delete';
    $dat[3]['width'] = '5%;';
    jrCore_page_table_header($dat);

    if ($_sc && is_array($_sc) && isset($_sc['_items'])) {
        foreach ($_sc['_items'] as $k => $_r) {
            $dat = array();
            $_us = array();
            if (!isset($_r['_user_id']) || $_r['_user_id'] == 0) {
                if ($eml = jrCustomForm_get_email_from_response($_r)) {
                    $_r['user_email'] = $eml;
                }
            }
            $_im   = array(
                '_item'  => $_r,
                'crop'   => 'portrait',
                'width'  => 96,
                'height' => 96,
                'alt'    => 'img',
                'title'  => 'img',
                '_v'     => (isset($_r['user_image_time']) && $_r['user_image_time'] > 0) ? $_r['user_image_time'] : false
            );
            $_us[] = jrImage_get_image_src('jrUser', 'user_image', $_r['_user_id'], 'medium', $_im);
            if (isset($_r['_user_id']) && jrCore_checktype($_r['_user_id'], 'number_nz')) {
                $_us[] = "<a href=\"{$_conf['jrCore_base_url']}/{$_r['profile_url']}\">@{$_r['profile_url']}</a>";
            }
            else {
                // Visitor...
                if (isset($_r['user_email'])) {
                    $_us[] = $_r['user_email'];
                }
            }
            $dat[1]['title'] = implode('<br>', $_us);
            $dat[1]['class'] = 'p10 center';
            $dat[2]['title'] = '<div class="ds_browser_item form_browser_item">' . jrCustomForm_format_response($_r) . '</div>';

            $_bt = array();
            if (isset($_r['user_email'])) {
                if (jrCore_module_is_active('jrTicket')) {
                    $turl  = jrCore_get_module_url('jrTicket');
                    $_bt[] = jrCore_page_button("response-response-{$k}", 'respond', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$turl}/create/email=" . urlencode($_r['user_email']) . "')");
                }
                else {
                    $_bt[] = "<a href=\"mailto:{$_r['user_email']}\" style=\"text-decoration:none\">" . jrCore_page_button("response-response-{$k}", 'respond', '') . '</a>';
                }
            }
            $_bt[]           = jrCore_page_button("response-delete-{$k}", 'remove', "jrCore_confirm('delete this response?','',function(){jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/response_delete_save/id={$_r['_item_id']}')})");
            $dat[3]['title'] = implode('<br><br>', $_bt);
            $dat[3]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_sc);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse");
    jrCore_page_display();
}
