<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: reset_categories_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_reset_categories_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['reset']) || $_post['reset'] != 'on') {
        jrCore_form_modal_notice('error', 'You need to check the Reset Categories checkbox!');
        jrCore_form_modal_notice('complete', 'errors were encountered resetting the categories');
        jrCore_db_close();
        exit;
    }

    $cnt = 0;
    $tbl = jrCore_db_table_name('jrCore', 'module');
    foreach ($_mods as $mod_dir => $_inf) {
        $_meta = jrCore_module_meta_data($mod_dir);
        if (isset($_meta['category']) && $_meta['category'] !== $_inf['module_category']) {
            $cat = jrCore_db_escape($_meta['category']);
            $req = "UPDATE {$tbl} SET module_updated = UNIX_TIMESTAMP(), module_category = '{$cat}' WHERE module_id = '{$_inf['module_id']}' LIMIT 1";
            $cnt += jrCore_db_query($req, 'COUNT');
        }
    }
    jrCore_form_modal_notice('update', "moved {$cnt} modules to new module category");

    // Reset caches
    jrCore_delete_all_cache_entries();

    jrCore_form_modal_notice('update', 'finished resetting the module categories');
    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', 'The module categories have been successfully reset');
    jrCore_db_close();
    exit;
}
