<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * quota_config
 */
function jrFollower_quota_config()
{
    // Allowed File Types
    $_opt = array(
        'user'   => 'User Option',
        'always' => 'Create Timeline entries for all follows',
        'never'  => 'No Timeline entries are created for follows',
    );
    $_tmp = array(
        'name'     => 'share_type',
        'default'  => '',
        'type'     => 'select',
        'options'  => $_opt,
        'label'    => 'Follow Timeline Control',
        'help'     => 'This setting controls whether or a not a Timeline entry is created when a user follows a profile:<br><br><b>User Option</b> - The User is in control if their follows show or not by setting the &quot;Share Who You Follow&quot; setting in the User Account section.<br><b>Create Timeline entries for all follows</b> - A timeline entry will always be created.<br><b>No Timeline entries are created for follows</b> - Timeline entries are never created.',
        'validate' => 'not_empty'
    );
    jrProfile_register_quota_setting('jrFollower', $_tmp);

    return true;
}
