<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_modify_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_modify_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_form_result();
    }
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_title, cat_title_url FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid category id (2)');
        jrCore_form_result();
    }
    $_ln = jrUser_load_lang_strings();

    jrCore_set_flag('master_html_trusted', 1);
    $nam = jrCore_db_escape($_post['cat_title']);
    $url = jrCore_db_escape(jrCore_url_string($_post['cat_title']));
    $dsc = jrCore_db_escape($_post['cat_desc']);
    $not = jrCore_db_escape($_post['cat_note']);
    $rdo = jrCore_db_escape($_post['cat_read_only']);

    // Update category entry
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "UPDATE {$tbl} SET cat_title = '{$nam}', cat_title_url = '{$url}', cat_desc = '{$dsc}', cat_note = '{$not}', cat_read_only = '{$rdo}' WHERE cat_id = '{$_post['id']}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {

        // We've updated - update all topics if we have changed
        if ($_rt['cat_title'] != $_post['cat_title']) {
            // We have changed - update
            $_sc = array(
                'search'         => array(
                    "forum_cat = {$_rt['cat_title']}",
                    "forum_profile_id = {$_profile['_profile_id']}"
                ),
                'return_keys'    => array('_item_id'),
                'skip_triggers'  => true,
                'ignore_pending' => true,
                'privacy_check'  => false,
                'limit'          => 1000000
            );
            $_tp = jrCore_db_search_items('jrForum', $_sc);
            if (is_array($_tp) && is_array($_tp['_items'])) {
                $_id = array();
                foreach ($_tp['_items'] as $_top) {
                    $tid       = (int) $_top['_item_id'];
                    $_id[$tid] = array(
                        'forum_cat'     => $_post['cat_title'],
                        'forum_cat_url' => jrCore_url_string($_post['cat_title'])
                    );
                }
                if (count($_id) > 0) {
                    jrCore_db_update_multiple_items('jrForum', $_id);
                }
                // Update view time categories
                $tbl = jrCore_db_table_name('jrForum', 'view');
                $req = "UPDATE IGNORE {$tbl} SET view_cat_url = '{$url}' WHERE view_profile_id = '{$_profile['_profile_id']}' AND view_cat_url = '" . jrCore_db_escape($_rt['cat_title_url']) . "'";
                jrCore_db_query($req);
            }
        }
        else {
            jrForum_update_category_counts($_profile['_profile_id'], $url);
        }
        jrForum_update_category_last_user_info($_profile['profile_id'], $url);
        jrProfile_reset_cache($_profile['_profile_id'], 'jrForum');
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', $_ln['jrForum'][83]);
    }
    else {
        jrCore_set_form_notice('error', $_ln['jrForum'][84]);
    }
    jrCore_form_result();
}
