<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: categories
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_categories($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // Start our create form
    jrCore_page_banner(57, null, false);

    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_id, cat_title, cat_desc, cat_order, cat_topic_count, cat_read_only FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' ORDER BY cat_order ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');

    $_ln = jrUser_load_lang_strings();

    $dat             = array();
    $dat[1]['title'] = $_ln['jrForum'][61];
    $dat[1]['width'] = '5%';
    $dat[2]['title'] = $_ln['jrForum'][1];
    $dat[2]['width'] = '58%';
    $dat[3]['title'] = $_ln['jrForum'][62];
    $dat[3]['width'] = '10%';
    $dat[4]['title'] = $_ln['jrForum'][60];
    $dat[4]['width'] = '10%';
    $dat[5]['title'] = $_ln['jrForum'][63];
    $dat[5]['width'] = '5%';
    $dat[6]['title'] = $_ln['jrForum'][64];
    $dat[6]['width'] = '5%';
    $dat[7]['title'] = $_ln['jrForum'][65];
    $dat[7]['width'] = '5%';
    jrCore_page_table_header($dat);

    $murl = jrCore_get_module_url('jrForum');
    if (is_array($_rt)) {
        foreach ($_rt as $k => $_cat) {
            $dat = array();
            if ($k > 0) {
                $dat[1]['title'] = jrCore_page_button("u{$k}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_order_save/id={$_cat['cat_id']}')");
            }
            else {
                $dat[1]['title'] = '';
            }
            $dat[2]['title'] = '<h3>' . $_cat['cat_title'] . '</h3>';
            $dat[3]['title'] = $_cat['cat_read_only'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = number_format($_cat['cat_topic_count']);
            $dat[4]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button("m{$k}", $_ln['jrForum'][64], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_modify/id={$_cat['cat_id']}')");
            if ($_cat['cat_topic_count'] > 0) {
                $dat[5]['title'] = jrCore_page_button("t{$k}", $_ln['jrForum'][63], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_transfer/id={$_cat['cat_id']}')");
                $dat[7]['title'] = jrCore_page_button("d{$k}", $_ln['jrForum'][65], 'disabled');
            }
            else {
                $dat[5]['title'] = jrCore_page_button("t{$k}", $_ln['jrForum'][63], 'disabled');
                $dat[7]['title'] = jrCore_page_button("d{$k}", $_ln['jrForum'][65], "if (confirm('Are you sure you want to delete this category?')) { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_delete_save/id={$_cat['cat_id']}') }");
            }
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = "<p>{$_ln['jrForum'][66]}</p>";
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => $_ln['jrForum'][67],
        'cancel'           => false,
        'action'           => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories_save",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Category Name
    $_tmp = array(
        'name'       => 'cat_title',
        'default'    => '',
        'type'       => 'text',
        'validate'   => 'printable',
        'required'   => 'on',
        'label'      => $_ln['jrForum'][68],
        'help'       => $_ln['jrForum'][69],
        'onkeypress' => "if (event && event.keyCode == 13) return false;"
    );
    jrCore_form_field_create($_tmp);
    return jrCore_page_display(true);
}
