<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: categories_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_categories_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    jrCore_form_validate($_post);

    $_ln = jrUser_load_lang_strings();

    // make sure cat is unique
    $nam = jrCore_db_escape($_post['cat_title']);
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_id FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_title = '{$nam}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (is_array($_rt)) {
        jrCore_set_form_notice('error', $_ln['jrForum'][70]);
        jrCore_location('referrer');
    }
    // New entries at bottom
    $req = "SELECT MAX(cat_order) AS morder FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}'";
    $_mx = jrCore_db_query($req, 'SINGLE');
    $ord = 0;
    if (isset($_mx['morder']) && jrCore_checktype($_mx['morder'], 'number_nn')) {
        $ord = $_mx['morder'] + 1;
    }
    $url = jrCore_db_escape(jrCore_url_string($_post['cat_title']));
    $req = "INSERT INTO {$tbl} (cat_profile_id, cat_title, cat_title_url, cat_order, cat_update_user) VALUES ('{$_profile['_profile_id']}', '{$nam}', '{$url}', '{$ord}', '')";
    $cid = jrCore_db_query($req, 'INSERT_ID');
    if ($cid && $cid > 0) {
        $url = jrCore_get_module_url('jrForum');
        jrProfile_reset_cache($_profile['_profile_id'], 'jrForum');
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', $_ln['jrForum'][71]);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$url}/cat_modify/id={$cid}");
    }
    jrCore_set_form_notice('error', $_ln['jrForum'][72]);
    jrCore_location('referrer');
}
