<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: settings
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_settings($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }

    // Start our create form
    jrCore_page_banner(31, null, false);

    // Get existing settings
    // Defaults
    $_rt = array(
        'enable_cats'   => 'off',
        'auto_lock'     => 0,
        'blocked_users' => ''
    );
    if (!empty($_user['profile_jrForum_settings'])) {
        $_rt = json_decode($_user['profile_jrForum_settings'], true);
    }

    $_ln = jrUser_load_lang_strings();

    // Form init
    $_tmp = array(
        'submit_value' => 32,
        'cancel'       => false,
        'action'       => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/" . jrCore_get_module_url('jrForum') . "/settings_save",
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // Use Categories
    $_tmp = array(
        'name'     => 'enable_cats',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'off',
        'label'    => 58,
        'help'     => 59
    );
    jrCore_form_field_create($_tmp);

    // Topic Auto Lock
    $days = $_ln['jrForum'][27];
    $_opt = array(
        0 => $_ln['jrForum'][26],
    );
    foreach (array(7, 10, 14, 21, 30, 60, 90, 120, 180, 365) as $day) {
        $_opt[$day] = "{$day} {$days}";
    }
    $_tmp = array(
        'name'     => 'auto_lock',
        'default'  => 0,
        'type'     => 'select',
        'options'  => $_opt,
        'validate' => 'number_nn',
        'required' => 'on',
        'label'    => 24,
        'help'     => 25
    );
    jrCore_form_field_create($_tmp);

    // Blocked Users
    $_tmp = array(
        'name'     => 'blocked_users',
        'default'  => '',
        'type'     => 'textarea',
        'validate' => 'printable',
        'required' => 'off',
        'label'    => 28,
        'help'     => 29
    );
    jrCore_form_field_create($_tmp);
    return jrCore_page_display(true);
}
