<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: user_settings_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_user_settings_save($_profile, $_post, $_user, $_conf)
{
    // Make sure user has access
    $acc = jrUser_get_profile_home_key('quota_jrForum_signature');
    if ($acc != 'on') {
        jrUser_not_authorized();
    }
    jrCore_form_validate($_post);

    $_up = array(
        'enable_signature' => $_post['enable_signature'],
        'signature'        => substr($_post['signature'], 0, 256)
    );
    $_up = array(
        'user_jrForum_settings' => json_encode($_up)
    );
    $_ln = jrUser_load_lang_strings();
    if (jrCore_db_update_item('jrUser', $_user['_user_id'], $_up)) {
        jrUser_reset_cache($_user['_user_id'], 'jrForum');
        jrUser_session_sync();
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', $_ln['jrForum'][124]);
    }
    else {
        jrCore_set_form_notice('error', $_ln['jrForum'][125]);
    }
    jrCore_location('referrer');
}
