<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: activity
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_activity($_post, $_user, $_conf)
{
    if (empty($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid profile_id');
    }
    $key = json_encode($_post);
    if ($out = jrCore_is_cached('jrForum', $key)) {
        return $out;
    }
    $_sp = array(
        'search'          => array(
            "_profile_id = {$_post['_1']}"
        ),
        'order_by'        => array(
            '_created' => 'desc'
        ),
        'quota_check'     => false,
        'simplepagebreak' => (isset($_conf['jrForum_index_count'])) ? intval($_conf['jrForum_index_count']) : 10,
        'page'            => 1
    );
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $_sp['page'] = (int) $_post['p'];
    }
    $_rt = jrCore_db_search_items('jrForum', $_sp);
    if (!$_rt || !is_array($_rt) || !is_array($_rt['_items'])) {
        jrCore_notice_page('notice', 94);
    }

    // get the categories and titles of the posts.
    // get group id's
    $_gi = array();
    foreach ($_rt['_items'] as $v) {
        if (isset($v['forum_group_id'])) {
            $_gi[] = (int) $v['forum_group_id'];
        }
    }

    // get the topics for these forum_group_id's
    $_tt = array();
    $_pr = array();
    $_sp = array(
        'search'         => array(
            "_item_id in " . implode(',', $_gi)
        ),
        'skip_triggers'  => true,
        'ignore_missing' => true,
        'quota_check'    => false,
        'limit'          => count($_gi)
    );
    $_gi = jrCore_db_search_items('jrForum', $_sp);
    if ($_gi && is_array($_gi) && is_array($_gi['_items'])) {
        foreach ($_gi['_items'] as $v) {
            $_tt["{$v['forum_group_id']}"] = $v;
            $_pr[]                         = $v['forum_profile_id'];
        }
    }

    // Get profile owners
    $_pi = array();
    if (count($_pr) > 0) {
        $_pr = jrCore_db_get_multiple_items('jrProfile', $_pr);
        if ($_pr && is_array($_pr)) {
            foreach ($_pr as $v) {
                $_pi["{$v['_profile_id']}"] = $v;
            }
        }
    }
    unset($_pr);

    $murl = jrCore_get_module_url('jrForum');
    // give each post access to the title of the thread
    foreach ($_rt['_items'] as $k => $v) {
        $_tmp                                 = $_tt["{$v['forum_group_id']}"];
        $fpid                                 = $_tmp['forum_profile_id'];
        $furl                                 = $_pi[$fpid]['profile_url'];
        $_rt['_items'][$k]['forum_title']     = $_tmp['forum_title'];
        $_rt['_items'][$k]['forum_title_url'] = $_tmp['forum_title_url'];
        $_rt['_items'][$k]['forum_topic_url'] = "{$_conf['jrCore_base_url']}/{$furl}/{$murl}/{$_tmp['forum_group_id']}/{$_tmp['forum_title_url']}";
        $_rt['_items'][$k]['forum_home_url']  = "{$_conf['jrCore_base_url']}/{$furl}/{$murl}";
        if (isset($_tmp['forum_cat'])) {
            $_rt['_items'][$k]['forum_cat']     = $_tmp['forum_cat'];
            $_rt['_items'][$k]['forum_cat_url'] = "{$_conf['jrCore_base_url']}/{$furl}/{$murl}/{$_tmp['forum_cat_url']}";
        }
    }
    $out = jrCore_parse_template('activity.tpl', $_rt, 'jrForum');
    jrCore_add_to_cache('jrForum', $key, $out);
    return $out;
}
