<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: attachment_delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_attachment_delete($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }
    // Make sure we get a good id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item('jrForum', $_post['id']);

    // Make sure the calling user has permission to delete this item
    if (!jrUser_is_admin() && !jrProfile_is_profile_owner($_rt['forum_profile_id']) && $_rt['_user_id'] != $_user['_user_id']) {
        jrUser_not_authorized();
    }
    // Is edit protection enabled?
    if (!jrUser_is_admin() && jrCore_checktype($_conf['jrForum_edit_protect'], 'number_nz') && $_rt['_created'] < (time() - $_conf['jrForum_edit_protect'])) {
        // Past timer - block edit
        jrUser_not_authorized();
    }

    // Delete attached item
    jrCore_delete_item_media_file('jrForum', 'forum_file', $_rt['_profile_id'], $_post['id']);
    $url = jrCore_get_local_referrer();
    jrProfile_reset_cache($_rt['forum_profile_id'], 'jrForum');
    jrCore_location("{$url}#r{$_post['id']}");
}
