<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: mark_all_topics_read
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_mark_all_topics_read($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    $tbl = jrCore_db_table_name('jrForum', 'view');
    $pid = intval($_post['_1']); // profile_id forum belongs to
    $uid = intval($_user['_user_id']);
    if (isset($_post['_2']) && strlen($_post['_2']) > 0 && $_post['_2'] != 'new_posts' && $_post['_2'] != 'my_posts') {
        $cat = jrCore_db_escape($_post['_2']);
        // Mark all topics read in category (or entire forum if no cat)
        $req = "INSERT INTO {$tbl} (view_user_id, view_profile_id, view_cat_url, view_topic_id, view_time)
                VALUES ('{$uid}', '{$pid}', '{$cat}', '4294967295', UNIX_TIMESTAMP()), ('{$uid}', '{$pid}', '{$cat}', '0', UNIX_TIMESTAMP())
                ON DUPLICATE KEY UPDATE view_time = UNIX_TIMESTAMP()";
        jrCore_db_query($req);
        if (isset($_SESSION['jrforum_new_posts'][$pid][$cat])) {
            unset($_SESSION['jrforum_new_posts'][$pid][$cat]);
        }
    }
    else {
        // Mark for for this profile
        $req = "UPDATE {$tbl} SET view_time = UNIX_TIMESTAMP() WHERE view_user_id = '{$uid}' AND view_profile_id = '{$pid}'";
        jrCore_db_query($req);
        if (isset($_SESSION['jrforum_new_posts'][$pid])) {
            unset($_SESSION['jrforum_new_posts'][$pid]);
        }
    }
    jrCore_delete_all_cache_entries('jrForum', $_user['_user_id']);
    jrCore_location('referrer');
}
