<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: post_delete_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_post_delete_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }
    // Make sure we get a good id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item('jrForum', $_post['id']);

    // Make sure the calling user has permission to edit this item
    if (!jrUser_is_admin() && !jrProfile_is_profile_owner($_rt['forum_profile_id']) && $_rt['_user_id'] != $_user['_user_id']) {
        jrUser_not_authorized();
    }
    // Is edit protection enabled?
    if (!jrUser_is_admin() && jrCore_checktype($_conf['jrForum_edit_protect'], 'number_nz') && $_rt['_created'] < (time() - $_conf['jrForum_edit_protect'])) {
        // Past timer - block edit
        jrUser_not_authorized();
    }

    // Delete item
    jrCore_db_delete_item('jrForum', $_post['id']);

    // If this is the FIRST ITEM (i.e. topic) we need to delete all responses
    if (isset($_rt['forum_title']) && isset($_rt['forum_group_id'])) {

        // Delete all responses
        $_fp = array(
            'search'              => array(
                "forum_group_id = {$_rt['forum_group_id']}"
            ),
            'return_item_id_only' => true,
            'quota_check'         => false,
            'skip_triggers'       => true,
            'ignore_pending'      => true,
            'privacy_check'       => false,
            'limit'               => 1000
        );
        $_fp = jrCore_db_search_items('jrForum', $_fp);
        if ($_fp && is_array($_fp)) {
            jrCore_db_delete_multiple_items('jrForum', $_fp);
        }

        // Next - we need to decrement the cat count
        $add = '';
        if (isset($_rt['forum_cat_url']) && strlen($_rt['forum_cat_url']) > 0) {
            $url = jrCore_db_escape($_rt['forum_cat_url']);
            $tbl = jrCore_db_table_name('jrForum', 'category');
            $req = "UPDATE {$tbl} SET cat_topic_count = (cat_topic_count - 1) WHERE cat_title_url = '{$url}' AND cat_profile_id = '{$_rt['forum_profile_id']}' AND cat_topic_count > 0";
            jrCore_db_query($req);
            $add = "/{$_rt['forum_cat_url']}";

            $_sp = array(
                'search'         => array(
                    "forum_profile_id = {$_rt['forum_profile_id']}",
                    "forum_post_count > 0",
                    "forum_cat_url = {$_rt['forum_cat_url']}"
                ),
                'order_by'       => array(
                    'forum_updated' => 'numerical_desc'
                ),
                'quota_check'    => false,
                'privacy_check'  => false,
                'ignore_pending' => true,
                'skip_triggers'  => true,
                'limit'          => 1
            );
            $_lp = jrCore_db_search_items('jrForum', $_sp);
            if (!empty($_lp['_items']) && isset($_lp['_items'][0]['forum_updated_user_id'])) {
                $uid = (int) $_lp['_items'][0]['forum_updated_user_id'];
                $_us = jrCore_db_get_item('jrUser', $uid);
                if ($_us && is_array($_us)) {
                    jrForum_set_category_last_user_info($_rt['forum_profile_id'], $_rt['forum_cat_url'], $_us);
                }
            }
        }

        // Delete any FOLLOWS for the topic
        $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
        $req = "DELETE FROM {$tbl} WHERE follow_forum_id = '{$_rt['forum_group_id']}'";
        jrCore_db_query($req);

        jrProfile_reset_cache($_rt['forum_profile_id'], 'jrForum');
        jrUser_reset_cache($_user['_user_id'], 'jrForum');

        // We've deleted an entire thread - return to forum index
        $url = $_rt['profile_url'];
        if ($_rt['_profile_id'] != $_rt['forum_profile_id']) {
            $url = jrCore_db_get_item_key('jrProfile', $_rt['forum_profile_id'], 'profile_url');
        }
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/{$_post['module_url']}{$add}");
    }

    else {

        // If this is the LAST POST, we need to update the topic leader with
        // the correct last updated by info
        $cat = false;
        $_fp = array(
            'search'         => array("forum_group_id = {$_rt['forum_group_id']}"),
            'order_by'       => array('_item_id' => 'numerical_asc'),
            'return_keys'    => array('_item_id', 'forum_cat_url'),
            'quota_check'    => false,
            'skip_triggers'  => true,
            'ignore_pending' => true,
            'privacy_check'  => false,
            'limit'          => 1000
        );
        $_fp = jrCore_db_search_items('jrForum', $_fp);
        if (isset($_fp['_items']) && is_array($_fp['_items'])) {
            $upd = true;
            $lid = 0;
            foreach ($_fp['_items'] as $v) {
                if (isset($v['forum_cat_url']) && !$cat) {
                    $cat = $v['forum_cat_url'];
                }
                if ($v['_item_id'] > $_rt['_item_id']) {
                    // we were not the last - no need to update
                    $upd = false;
                    break;
                }
                else {
                    $lid = $v['_item_id'];
                }
            }
            if ($upd && $lid > 0) {
                // No items had an ID larger than ours, so we were last
                $_lp = jrCore_db_get_item('jrForum', $lid);
                $_dt = array(
                    'forum_updated'         => $_lp['_created'],
                    'forum_updated_user_id' => $_lp['_user_id'],
                );
                jrCore_db_update_item('jrForum', $_rt['forum_group_id'], $_dt);
            }
        }
        unset($_fp);

        // Decrement post count
        jrCore_db_decrement_key('jrForum', $_rt['forum_group_id'], 'forum_post_count', 1);

        // Next, if this topic as the NEWEST topic in a forum category, we need to
        // update the category leader with the LAST user info on this topic
        if ($cat) {
            jrForum_update_category_last_user_info($_rt['forum_profile_id'], $cat);
        }
    }

    // If we are using categories and this was the NEWEST post in the category that
    // was deleted, we need to update the category info so it shows the right user
    $_tl = jrCore_db_get_item('jrForum', $_rt['forum_group_id'], true);
    if (isset($_tl['forum_cat_url']) && strlen($_tl['forum_cat_url']) > 0) {
        // Find the LAST user that updated this category
        // This first search gets us the last topic in the category
        $_sp = array(
            'search'         => array(
                "_profile_id = {$_tl['forum_profile_id']}",
                "forum_cat_url = {$_tl['forum_cat_url']}"
            ),
            'order_by'       => array('_item_id' => 'desc'),
            'skip_triggers'  => true,
            'ignore_pending' => true,
            'privacy_check'  => false,
            'limit'          => 1
        );
        $_op = jrCore_db_search_items('jrForum', $_sp);
        if ($_op && is_array($_op) && isset($_op['_items'])) {

            // This next search gets us the last POSTER in the LAST topic
            $_sp = array(
                'search'         => array(
                    "forum_group_id = {$_op['_items'][0]['forum_group_id']}"
                ),
                'order_by'       => array('_item_id' => 'desc'),
                'skip_triggers'  => true,
                'ignore_pending' => true,
                'privacy_check'  => false,
                'limit'          => 1
            );
            $_op = jrCore_db_search_items('jrForum', $_sp);
            if ($_op && is_array($_op) && isset($_op['_items'])) {
                $_us = jrCore_db_get_item('jrUser', $_op['_items'][0]['_user_id']);
                if ($_us && is_array($_us)) {
                    jrForum_set_category_last_user_info($_tl['forum_profile_id'], $_tl['forum_cat_url'], $_us);
                }
            }
        }
    }

    jrProfile_reset_cache($_rt['forum_profile_id'], 'jrForum');
    jrCore_form_result();
}
