<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: toggle_cat_watch
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_toggle_cat_watch($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }
    // We must get a valid ID
    if (!isset($_post['cat_id']) || !jrCore_checktype($_post['cat_id'], 'number_nz')) {
        jrCore_json_response(array('error' => 'invalid forum id'));
    }
    $_ln = jrUser_load_lang_strings();
    $cid = (int) $_post['cat_id'];
    $uid = (int) $_user['_user_id'];
    $tbl = jrCore_db_table_name('jrForum', 'follow_category');
    $req = "SELECT follow_cat_id FROM {$tbl} WHERE follow_cat_id = '{$cid}' AND follow_user_id = '{$uid}' LIMIT 1";
    $fol = jrCore_db_query($req, 'SINGLE');
    // toggle
    if (!$fol) {
        $req = "INSERT IGNORE INTO {$tbl} (follow_cat_id,follow_user_id) VALUES ('{$cid}','{$uid}')";
        $tag = $_ln['jrForum'][119];
        $fol = 'on';
    }
    else {
        $req = "DELETE FROM {$tbl} WHERE follow_cat_id = '{$cid}' AND follow_user_id = '{$uid}'";
        $tag = $_ln['jrForum'][120];
        $fol = 'off';
    }
    jrCore_db_query($req);

    // reset forum cache for this user
    jrCore_delete_all_cache_entries('jrForum', $_user['_user_id']);

    $_response = array(
        'success'   => true,
        'following' => $fol,
        'tag'       => $tag
    );
    jrCore_json_response($_response);
}
