<?php
 /**
 * Jamroom Google Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: experiment_browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrGoogleAnalytics_experiment_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrGoogleAnalytics', 'experiment_browse');
    jrCore_page_banner('A/B Testing Browser');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'original URL';
    $dat[1]['width'] = '38%';
    $dat[2]['title'] = 'variant URL';
    $dat[2]['width'] = '38%';
    $dat[3]['title'] = 'active';
    $dat[3]['width'] = '5%';
    $dat[4]['title'] = 'modify';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }

    $tbl = jrCore_db_table_name('jrGoogleAnalytics', 'experiment');
    $req = "SELECT * FROM {$tbl} ORDER BY e_created DESC";
    $_rt = jrCore_db_paged_query($req, $page, 12, 'NUMERIC', jrCore_db_number_rows('jrGoogleAnalytics', 'experiment'));

    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        $pass = jrCore_get_option_image('pass');
        $fail = jrCore_get_option_image('fail');
        foreach ($_rt['_items'] as $k => $_u) {
            $dat = array();
            if ($_u['e_urlone'] == '/') {
                $dat[1]['title'] = "<a href=\"{$_conf['jrCore_base_url']}\" target=\"_blank\">{$_u['e_urlone']}</a>";
            }
            else {
                $dat[1]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_u['e_urlone']}\" target=\"_blank\">/{$_u['e_urlone']}</a>";
            }
            $dat[2]['title'] = '/' . $_u['e_urltwo'];
            $dat[3]['title'] = ($_u['e_active'] == 'on') ? $pass : $fail;
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button("url-update-{$k}", "modify", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/experiment_modify/{$_u['e_id']}')");
            $dat[5]['title'] = jrCore_page_button("url-delete-{$k}", "delete", "jrCore_confirm('', 'Are you sure you wanto to delete this experiment?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/experiment_delete_save/{$_u['e_id']}') } )");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'No Experiments have been created';
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => 'create new experiment',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Original URL
    $_tmp = array(
        'name'     => 'e_urlone',
        'label'    => 'Original URL',
        'help'     => 'Enter the Original URL that you want to run the A/B test on - the "A" URL.<br><br>This is the URL you will link to from another site.',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true,
        'section'  => 'create a new experiment'
    );
    jrCore_form_field_create($_tmp);

    // Variant URL
    $_tmp = array(
        'name'     => 'e_urltwo',
        'label'    => 'Variant URL',
        'help'     => 'Enter the Variant URL that you want to run the A/B test on - the "B" URL',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Experiment Key
    $_tmp = array(
        'name'     => 'e_key',
        'label'    => 'Experiment Key',
        'help'     => 'Enter the Google Analytics Experiment Key that was created for this experiment.<br><br><b>NOTE:</b> The Experiment Key <b>must</b> already have been created in your Google Analytics -> Experiments section AND be enabled for A/B testing to work.',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
