<?php
 /**
 * Jamroom Email Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: campaign_result
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMailer_campaign_result($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrUser_master_only();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid campaign id');
    }
    $cid = (int) $_post['_1'];

    $url = jrCore_get_local_referrer();
    if (!strpos($url, '/campaign_result/')) {
        jrCore_create_memory_url('campaign_cancel', $url);
    }

    $_cp = jrMailer_get_campaign_results(array($cid));
    if (!$_cp || !is_array($_cp) || !isset($_cp[$cid]) || !is_array($_cp[$cid])) {
        jrCore_notice_page('error', 'invalid campaign id (2)');
    }
    $_cp = $_cp[$cid];

    $_inc = array('source' => "https://www.gstatic.com/charts/loader.js", 'include_version' => false);
    jrCore_create_page_element('javascript_href', $_inc);

    $_inc = array('source' => "https://maps.googleapis.com/maps/api/js?key={$_conf['jrGeo_google_api_key']}", 'include_version' => false);
    jrCore_create_page_element('javascript_href', $_inc);

    $_inc = array('jrMailer_cp_init()');
    jrCore_create_page_element('javascript_ready_function', $_inc);

    if (isset($_cp['countries'])) {
        arsort($_cp['countries']);
    }
    $_cp['results']['c_percent'] = 0;
    if (isset($_cp['results']['total']) && $_cp['results']['total'] > 0) {
        $_cp['results']['c_percent'] = floor(($_cp['results']['total'] / $_cp['campaign']['c_sent']) * 100);
        if ($_cp['results']['c_percent'] > 100) {
            $_cp['results']['c_percent'] = 100;
        }
    }
    $mod = $_cp['campaign']['c_module'];
    jrCore_page_title("{$_mods[$mod]['module_name']}: {$_cp['campaign']['c_title']} - Campaign");

    // Create all campaigns Jumper
    $_camps = jrMailer_get_all_campaigns();
    $cm_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/campaign_result/";
    $button = '<select name="campaign_id" class="form_select form_select_item_jumper" onchange="jrCore_window_location(\'' . $cm_url . "'+ $(this).val())\">\n";
    foreach ($_camps as $cpid => $_inf) {
        if ($cpid == $_post['_1']) {
            $button .= '<option value="' . $cpid . '" selected="selected"> ' . $_inf['c_title'] . ' (' . jrCore_format_time($_inf['c_created']) . ")</option>\n";
        }
        else {
            $button .= '<option value="' . $cpid . '"> ' . $_inf['c_title'] . ' (' . jrCore_format_time($_inf['c_created']) . ")</option>\n";
        }
    }
    $button .= '</select>';

    $button .= jrCore_page_button('refresh', 'refresh', 'location.reload()');

    if ($mod == 'jrNewsLetter') {
        $url = jrCore_get_module_url('jrNewsLetter');
        jrCore_page_banner("<a href=\"{$_conf['jrCore_base_url']}/{$url}/browse\"><u>{$_mods[$mod]['module_name']}</u></a> - {$_cp['campaign']['c_title']}", $button);
    }
    else {
        jrCore_page_banner("{$_mods[$mod]['module_name']}: {$_cp['campaign']['c_title']}", $button);
    }
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'total sent';
    $dat[1]['width'] = '16.6%';
    $dat[2]['title'] = 'unique opens';
    $dat[2]['width'] = '16.6%';
    $dat[3]['title'] = 'open percent';
    $dat[3]['width'] = '16.6%';
    $dat[4]['title'] = 'clicked URLs';
    $dat[4]['width'] = '16.6%';
    $dat[5]['title'] = 'unsubscribes';
    $dat[5]['width'] = '16.6%';
    $dat[6]['title'] = 'bounces';
    $dat[6]['width'] = '16.6%';

    // Let the module insert or change our header
    $dat = jrCore_trigger_event('jrMailer', 'campaign_result_header', $dat, $_cp, $mod);
    jrCore_page_table_header($dat);

    $dat             = array();
    $dat[1]['title'] = (isset($_cp['campaign']['c_sent'])) ? jrCore_number_format($_cp['campaign']['c_sent']) : 0;
    $dat[1]['class'] = 'bignum bignum4 nocursor';
    $dat[2]['title'] = (isset($_cp['results']['total'])) ? jrCore_number_format($_cp['results']['total']) : 0;
    $dat[2]['class'] = 'bignum bignum3 nocursor';
    $dat[3]['title'] = (isset($_cp['results']['c_percent'])) ? $_cp['results']['c_percent'] . '%' : '0%';
    if ($_cp['results']['c_percent'] > 25) {
        $dat[3]['class'] = 'bignum bignum3 nocursor';
    }
    elseif ($_cp['results']['c_percent'] > 10) {
        $dat[3]['class'] = 'bignum bignum2 nocursor';
    }
    else {
        $dat[3]['class'] = 'bignum bignum1 nocursor';
    }
    $dat[4]['title'] = (isset($_cp['results']['clicks'])) ? jrCore_number_format($_cp['results']['clicks']) : 0;
    $dat[4]['class'] = 'bignum bignum3 nocursor';
    $dat[5]['title'] = (isset($_cp['campaign']['c_unsub'])) ? jrCore_number_format($_cp['campaign']['c_unsub']) : 0;
    if ($_cp['campaign']['c_unsub'] > 0) {
        $dat[5]['class'] = 'bignum bignum1 nocursor';
    }
    else {
        $dat[5]['class'] = 'bignum bignum3 nocursor';
    }
    if (jrCore_module_is_active('jrMailGun')) {
        $dat[6]['title'] = (isset($_cp['campaign']['c_bounce'])) ? "<a href=\"{$_conf['jrCore_base_url']}/" . jrCore_get_module_url('jrMailGun') . '/browse_bounces"><u>' . jrCore_number_format($_cp['campaign']['c_bounce']) . '</u></a>' : 0;
    }
    else {
        $dat[6]['title'] = (isset($_cp['campaign']['c_bounce'])) ? jrCore_number_format($_cp['campaign']['c_bounce']) : 0;
    }
    if ($_cp['campaign']['c_bounce'] > 0) {
        $dat[6]['class'] = 'bignum bignum1 nocursor';
    }
    else {
        $dat[6]['class'] = 'bignum bignum3 nocursor';
    }

    // Let the module insert or change our row
    $dat = jrCore_trigger_event('jrMailer', 'campaign_result_row', $dat, $_cp, $mod);
    jrCore_page_table_row($dat);

    jrCore_page_table_footer();

    $_cp['module'] = jrCore_module_meta_data($_cp['campaign']['c_module']);

    if (!isset($_post['_2'])) {
        $_post['_2'] = 'view';
    }
    jrMailer_campaign_tabs($_post['_2']);

    switch ($_post['_2']) {
        case 'map':
            if (isset($_cp['countries']) && is_array($_cp['countries'])) {
                $_new = array();
                foreach ($_cp['countries'] as $country => $count) {
                    $new_country        = jrMailer_get_country_name_for_map($country);
                    $_new[$new_country] = $count;
                }
                $_cp['countries'] = $_new;
                unset($_new);
            }
            $html = jrCore_parse_template('campaign_user_map.tpl', $_cp, 'jrMailer');
            break;
        case 'unsub':
            $_cp['unsub'] = jrMailer_get_unsubscribed_users($cid);
            if (!is_array($_cp['unsub']) || count($_cp['unsub']) === 0) {
                unset($_cp['unsub']);
            }
            $html = jrCore_parse_template('campaign_user_unsubscribe.tpl', $_cp, 'jrMailer');
            break;
        case 'urls':
            $html = jrCore_parse_template('campaign_urls.tpl', $_cp, 'jrMailer');
            break;
        default:
            $html = jrCore_parse_template('campaign_views.tpl', $_cp, 'jrMailer');
            break;
    }
    jrCore_page_custom($html);
    $url = jrCore_get_memory_url('campaign_cancel');
    if ($url) {
        jrCore_page_cancel_button($url);
    }
    jrCore_page_display();
}
