// Jamroom Marketplace Module Javascript
// @copyright 2003-2013 by Talldude Networks LLC
// @author Brian Johnson - brian@jamroom.net

/**
 * Update all items that have updates
 */
function jrMarket_update_all_items(t)
{
    $('#modal_window').modal();
    $('#modal_indicator').show();
    var s = setInterval(function() {
        $.ajax({
            cache: false,
            dataType: 'json',
            url: core_system_url + '/' + jrCore_url + '/form_modal_status/k=' + t + '/__ajax=1',
            success: function(t, a, x) {
                jrFormModalSubmit_update_process(t, s);
            },
            error: function(r, t, e) {
                clearInterval(s);
                jrCore_alert('An error was encountered communicating with the server: ' + t + ': ' + e);
            }
        })
    }, 1000);
    $.getJSON(core_system_url + '/' + jrMarket_url + '/update_all_items/__ajax=1', function(r, a, x) {
        if (r !== null && typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
    });
}

/**
 * Submits a Quick Purchase
 * @return bool
 */
function jrMarket_quick_purchase(type, price, id, item)
{
    $(this).attr("disabled", "disabled").addClass('form_button_disabled');
    var iid = '#fsi_' + id;
    var mid = Number(id);
    $(iid).show(300, function() {
        var u = core_system_url + '/' + jrMarket_url + '/purchase/__ajax=1';
        jrCore_set_csrf_cookie(u);
        $.post(u, {
            type: type,
            price: price,
            market_id: id,
            item: item
        }, function(m) {
            if (typeof m.error !== "undefined") {
                $(iid).hide(300, function() {
                    jrCore_alert(m.error);
                });
            }
            else {
                u = core_system_url + '/' + jrMarket_url + '/install_item/' + type + '/' + m.name + '/' + mid + '/license=' + m.license + '/__ajax=1';
                jrCore_set_csrf_cookie(u);
                $.getJSON(u, function(r) {
                    // Check for error
                    if (typeof r.error !== "undefined") {
                        $(iid).hide(300, function() {
                            jrCore_alert(r.error);
                        });
                    }
                    else {
                        if (typeof r.redirect !== "undefined") {
                            // We had an error
                            window.location.reload();
                        }
                        else {
                            window.location = r.url;
                        }
                    }
                });
            }
        });
    });
    return false;
}

/**
 * Install a Free Item
 * @return bool
 */
function jrMarket_install_item(type, id, item)
{
    $(this).jrCore_disable_button();
    var iid = '#fsi_' + id;
    var mid = Number(id);
    $(iid).show(300, function() {
        var u = core_system_url + '/' + jrMarket_url + '/license_item/' + type + '/' + item + '/' + mid + '/__ajax=1';
        jrCore_set_csrf_cookie(u);
        $.getJSON(u, function(m) {
            // Check for error
            if (typeof m.error !== "undefined") {
                $(iid).hide(300, function() {
                    jrCore_alert(m.error);
                });
            }
            else if (typeof m.license !== "undefined" && m.license.length > 0) {
                u = core_system_url + '/' + jrMarket_url + '/install_item/' + type + '/' + item + '/' + mid + '/license=' + m.license + '/__ajax=1';
                jrCore_set_csrf_cookie(u);
                $.getJSON(u, function(r) {
                    // Check for error
                    if (typeof r.error !== "undefined") {
                        $(iid).hide(300, function() {
                            jrCore_alert(r.error);
                        });
                    }
                    else {
                        if (typeof r.redirect !== "undefined") {
                            // We had an error
                            window.location.reload();
                        }
                        else {
                            window.location = r.url;
                        }
                    }
                });
            }
            else {
                jrCore_alert('Unable to retrieve a license for the item - please try again');
            }
        });
    });
    return false;
}

/**
 * Update/Reload an existing item
 * @param type skin|module
 * @param dir module|skin directory
 * @param r reload
 * @param id Marketplace ID
 * @returns {boolean}
 */
function jrMarket_update_item(type, dir, r, id)
{
    var bid = '#u' + dir;
    var img = $('#u' + dir + '_spinner');
    $(bid).fadeOut(200, function() {
        $('input').jrCore_disable_button();
        $(img).show(300, function() {
            var u = core_system_url + '/' + jrMarket_url + '/update_item/' + type + '/' + dir;
            if (typeof r != "undefined" && r === 'reload') {
                u = u + '/reload';
            }
            u = u + '/id=' + Number(id) + '/__ajax=1';
            jrCore_set_csrf_cookie(u);
            $.getJSON(u, function(s) {
                window.location = s.url;
            });
        });
    });
    return false;
}
