<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: release_system_update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_release_system_update_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    // Make sure this does not already exist
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid system_id - please try again');
        jrCore_form_result();
    }
    $tbl = jrCore_db_table_name('jrMarket', 'system');
    $req = "SELECT * FROM {$tbl} WHERE system_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid system_id - not found in DB - please try again');
        jrCore_form_result();
    }
    // Update
    $url = jrCore_db_escape($_post['system_url']);
    $nam = jrCore_db_escape($_post['system_name']);
    $eml = jrCore_db_escape($_post['system_email']);
    $cod = jrCore_db_escape($_post['system_code']);
    $req = "UPDATE {$tbl} SET system_name = '{$nam}', system_url = '{$url}', system_email = '{$eml}', system_code = '{$cod}', system_active = '{$_post['system_active']}', system_default = '{$_post['system_default']}' WHERE system_id = '{$_post['id']}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {
        // Make sure any other system is no longer the default if changed
        if ($_post['system_default'] == 'on') {
            $req = "UPDATE {$tbl} SET system_default = 'off' WHERE system_id != '{$_post['id']}'";
            jrCore_db_query($req);
        }
        jrUser_delete_session_key('market_release_system');
        unset($_SESSION['JRMARKET_INFO']);
        jrCore_delete_all_cache_entries();
        jrCore_set_form_notice('success', "The System has been successfully updated");
        jrCore_form_delete_session();
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered updating the System - please try again');
    }
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse");
}
