<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: archive_view
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_archive_view($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Get language strings
    $_lang = jrUser_load_lang_strings();

    // Check parameter
    if (jrCore_checktype($_post['_1'], 'number_nz')) {
        // Get newsletter
        if ($_nl = jrCore_db_get_item('jrNewsLetter', $_post['_1'], true)) {
            // Test that this user is allowed to view newsletter
            $valid = false;
            $tbl   = jrCore_db_table_name('jrNewsLetter', 'emails');
            $req   = "SELECT `e_lid` AS nlid FROM {$tbl} WHERE `e_emails` LIKE '%{$_user['user_email']}%' AND `e_lid` = '{$_post['_1']}' LIMIT 1";
            if (jrCore_db_query($req, $_post['p'], 'SINGLE')) {
                $valid = true;
            }
            if ($valid) {
                // Show newsletter
                jrCore_page_banner($_nl['letter_title'], $_lang['jrNewsLetter'][8]);
                jrCore_page_custom($_nl['letter_message']);
            }
            else {
                jrCore_page_notice('error', $_lang['jrNewsLetter'][9]);
            }
        }
        else {
            jrCore_page_notice('error', $_lang['jrNewsLetter'][10]);
        }
    }
    else {
        jrCore_page_notice('error', $_lang['jrNewsLetter'][11]);
    }

    // Back button
    jrCore_page_note(jrCore_page_button('back', $_lang['jrNewsLetter'][12], "history.back()"));
    jrCore_page_display();
}
