<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: get_recipient_count
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_get_recipient_count($_post, $_user, $_conf)
{
    ini_set('max_execution_time', 60);
    jrUser_master_only();
    jrCore_validate_location_url();
    $num = 0;
    $tst = false;
    if (isset($_post['letter_quota']) && is_array($_post['letter_quota'])) {
        // Are we doing tests?
        $dec = false;
        foreach ($_post['letter_quota'] as $opt) {
            if (strpos(' ' . $opt, 'test_')) {
                // This is a test
                switch ($opt) {
                    case 'test_user':
                        $num += 1;
                        $dec = true;
                        $tst = true;
                        break;
                    case 'test_master':
                        $num += jrCore_db_run_key_function('jrUser', 'user_group', 'master', 'COUNT');
                        $tst = true;
                        break;
                    case 'test_admin':
                        $num = 0;
                        if ($_rt = jrCore_db_get_multiple_items_by_key('jrUser', 'user_group', array('master','admin'), true)) {
                            $num = count($_rt);
                        }
                        $tst = true;
                        break;
                }
            }
        }
        if ($dec && in_array('test_master', $_post['letter_quota'])) {
            $num--; // We included test_user AND test_master - but we are a master
        }
    }
    if ($num === 0 && !$tst) {
        $_custom = array();
        foreach ($_post as $k => $v) {
            if (strpos($k, 'letter_custom') === 0 && !empty($v)) {
                $_custom[] = trim($v);
            }
        }
        $num = (int) jrNewsLetter_get_matching_recipients($_post['letter_quota'], $_post['letter_filter'], $_custom, true);
    }
    $_rp = array(
        'num'  => intval($num),
        'numf' => jrCore_number_format($num)
    );
    jrCore_json_response($_rp, true, false);
}
