<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: template_browser
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_template_browser($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrNewsLetter');

    jrCore_page_banner('Template Browser');
    jrCore_get_form_notice();

    $p = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $p = (int) $_post['p'];
    }
    $tbl = jrCore_db_table_name('jrNewsLetter', 'template');
    $req = "SELECT * FROM {$tbl} ORDER BY t_time DESC";
    $_rt = jrCore_db_paged_query($req, $p, 12);

    $dat             = array();
    $dat[1]['title'] = 'title';
    $dat[1]['width'] = '60%';
    $dat[2]['title'] = 'updated';
    $dat[2]['width'] = '20%';
    $dat[3]['title'] = 'size';
    $dat[3]['width'] = '10%';
    $dat[4]['title'] = 'edit';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt) && is_array($_rt['_items'])) {

        foreach ($_rt['_items'] as $k => $_l) {

            $dat             = array();
            $dat[1]['title'] = $_l['t_title'];
            $dat[2]['title'] = jrCore_format_time($_l['t_time']);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrCore_format_size(strlen($_l['t_template']));
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button("r{$k}", 'edit template', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/edit_newsletter_template/id={$_l['t_id']}')");
            $dat[5]['title'] = jrCore_page_button("d{$k}", 'delete', "jrCore_confirm('', 'Delete this template?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/template_delete_save/id={$_l['t_id']}') } )");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No Templates have been created yet<br>Press &quot;Save As New Template&quot; when creating a newsletter to save it as a template</p>';
        $dat[1]['class'] = 'p10 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
