<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: unsubscribe
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_unsubscribe($_post, $_user, $_conf)
{
    $_ln = jrUser_load_lang_strings();
    $url = jrCore_get_base_url();
    if (empty($_post['_2']) || !jrCore_checktype($_post['_2'], 'md5')) {
        jrCore_notice_page('error', 'Invalid newsletter subscription ID<br><br>Please make sure you are entering the full URL from the unsubscribe link (2)', $url, $_ln['jrCore'][87], false);
    }
    // Fall through - this user has an ACCOUNT on the system
    if (jrUser_is_logged_in()) {
        // User is logged in - redirect to notifications tab
        $pid = jrUser_get_profile_home_key('_profile_id');
        jrCore_location("{$url}/{$_post['module_url']}/notifications/profile_id={$pid}/user_id={$_user['_user_id']}");
    }
    if (!$_us = jrCore_db_get_item_by_key('jrUser', 'user_validate', $_post['_2'], true)) {
        jrCore_notice_page('error', 'Invalid unique subscriber ID<br><br>Please make sure you are entering the full URL from the unsubscribe link', $url, $_ln['jrCore'][87], false);
    }
    // Is this user already FULLY unsubscribed?
    if (!empty($_us['user_notifications_disabled']) && $_us['user_notifications_disabled'] == 'on') {
        // Yes - let them know
        jrCore_notice_page('success', $_ln['jrUser'][95], jrCore_get_base_url(), $_ln['jrCore'][87]);
    }
    elseif (isset($_us['user_jrNewsLetter_newsletter_notifications']) && $_us['user_jrNewsLetter_newsletter_notifications'] == 'on') {
        // They are already unsubscribed from the NEWSLETTER only
        jrCore_notice_page('success', $_ln['jrNewsLetter'][3], jrCore_get_base_url(), $_ln['jrCore'][87]);
    }

    // Handle campaign unsubscribe
    $uid = (int) $_us['_user_id'];
    if (!empty($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz') && jrCore_module_is_active('jrMailer')) {
        if ($_rt = jrMailer_get_campaign_info_by_md5($_post['_1'])) {

            // count our unsubscribe - as long as we didn't already
            $cnt = jrMailer_set_unsubscribe_flag($_us['_user_id'], $_rt['c_id']);
            if ($cnt === 1) {

                $cid = (int) $_rt['c_id'];
                $tb1 = jrCore_db_table_name('jrMailer', 'campaign');
                $tb2 = jrCore_db_table_name('jrMailer', 'track');
                $_rq = array(
                    "UPDATE {$tb1} SET c_unsub = (c_unsub + 1) WHERE c_id = {$cid}",
                    "UPDATE {$tb2} SET t_unsub = 1 WHERE t_cid = {$cid} AND t_uid = {$uid}'"
                );
                jrCore_db_multi_query($_rq, false);
            }
        }
    }

    // Unsubscribe instantly
    $_up = array('user_jrNewsLetter_newsletter_notifications' => 'off');
    jrCore_db_update_item('jrUser', $uid, $_up, null, false, true, false);
    jrCore_notice_page('success', $_ln['jrNewsLetter'][3], jrCore_get_base_url(), $_ln['jrCore'][87]);
}
