<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: charge
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_charge($_post, $_user, $_conf)
{
    jrUser_admin_only();
    if (jrUser_is_master()) {
        jrCore_page_admin_tabs('jrPayment');
        jrCore_page_include_admin_menu();
    }

    // Our active plugin must support point-of-sale
    $plug = jrPayment_get_active_plugin();
    $_mta = jrPayment_get_plugin_meta_data($plug);
    if (empty($_mta['point-of-sale']) || $_mta['point-of-sale'] !== true) {
        jrCore_notice_page('error', 'The current active Payment processor does not support Point of Sale payments');
    }

    jrCore_page_banner('process a one time payment');
    jrCore_get_form_notice();

    // User Picker
    $_tmp = array(
        'name'        => 'charge_user_email',
        'label'       => 'User Account',
        'help'        => 'Select the User Account to apply this new charge to.',
        'type'        => 'live_search',
        'target'      => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/get_charge_users",
        'required'    => false,
        'validate'    => 'number_nz',
        'placeholder' => 'Start typing to search users',
        'onkeypress'  => "if (event && event.keyCode > 0) { $('#charge_user_email').removeClass('field-hilight') }"
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'        => 'charge_amount',
        'label'       => 'Amount',
        'help'        => 'Enter the amount of the charge.<br><br>This should be entered as a price such as <b>9.99</b> - do not include a dollar sign.',
        'type'        => 'text',
        'validate'    => 'price',
        'required'    => true,
        'placeholder' => '0.00',
        'onkeypress'  => "if (event && event.keyCode > 0) { $('#charge_amount').removeClass('field-hilight') }"
    );
    jrCore_form_field_create($_tmp);

    if ($onc = jrPayment_run_plugin_function('charge_onclick')) {
        $button = jrCore_page_button('charge', 'process charge', $onc);
        jrCore_page_custom($button, '&nbsp;');
    }

    jrCore_page_display();
}
