<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_register_entry
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_create_register_entry($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment', 'payments');
    jrCore_page_include_admin_menu();
    jrCore_page_banner('Create Payment');
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value' => 'create payment',
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_user_email',
        'label'    => 'email address',
        'help'     => 'Enter the email address used in this transaction',
        'type'     => 'text',
        'validate' => 'email',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_id',
        'label'    => 'transaction ID',
        'help'     => 'Enter the transaction ID for this transaction',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_total',
        'label'    => 'income',
        'help'     => 'Enter any income associated with this transaction',
        'type'     => 'text',
        'validate' => 'price',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_expense',
        'label'    => 'expense',
        'help'     => 'Enter any expense associated with this transaction',
        'type'     => 'text',
        'validate' => 'price',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_date',
        'label'    => 'date',
        'help'     => 'Enter the date this transaction occured on',
        'type'     => 'datetime',
        'validate' => 'date',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $tbl  = jrCore_db_table_name('jrPayment', 'register');
    $req  = "SELECT r_tag FROM {$tbl} WHERE r_module = 'jrPayment' GROUP BY r_tag ORDER BY r_tag ASC";
    $_rt  = jrCore_db_query($req, 'r_tag', false, 'r_tag');
    $_tmp = array(
        'name'     => 'txn_category',
        'label'    => 'category',
        'help'     => 'Enter a category for this transaction',
        'type'     => 'select_and_text',
        'options'  => $_rt,
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'txn_note',
        'label'    => 'details',
        'help'     => 'Enter any additional info about this transaction you would like to save',
        'type'     => 'textarea',
        'validate' => 'printable',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    return jrCore_page_display(true);
}
