<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: import
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_import($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrPayment');

    if (!isset($_mods['jrFoxyCart'])) {
        $show = false;
        jrCore_set_form_notice('error', 'The FoxyCart eCommerce module is not installed');
    }
    else {
        $show = true;
        jrCore_set_form_notice('success', "This tool will attempt to import existing FoxyCart payments in to the Payment Support module");
    }
    jrCore_page_banner('import FoxyCart payments');
    jrCore_get_form_notice();

    if ($show) {
        $_tmp = array(
            'submit_value'  => 'import payments',
            'cancel'        => 'referrer',
            'submit_title'  => 'Import Payments from FoxyCart?',
            'submit_prompt' => 'Please be patient while the payments are imported',
            'submit_modal'  => 'update',
            'modal_width'   => 600,
            'modal_height'  => 400,
            'modal_note'    => 'Please be patient while the payments are imported'
        );
        jrCore_form_create($_tmp);

        $_tmp = array(
            'name'     => 'item_payments',
            'label'    => 'import item payments',
            'help'     => 'If this option is checked, existing item payments will be imported into the Payment Support module',
            'type'     => 'checkbox',
            'validate' => 'onoff',
            'default'  => 'on',
            'required' => true
        );
        jrCore_form_field_create($_tmp);

        if (jrCore_module_is_active('jrSubscribe')) {
            $_tmp = array(
                'name'     => 'sub_payments',
                'label'    => 'import subscription payments',
                'help'     => 'If this option is checked, existing subscription payments will be imported into the Payment Support module',
                'type'     => 'checkbox',
                'validate' => 'onoff',
                'default'  => 'on',
                'required' => true
            );
            jrCore_form_field_create($_tmp);
        }

        $_tmp = array(
            'name'     => 'ledger_payments',
            'label'    => 'import manual transactions',
            'help'     => 'If this option is checked, existing transactions that were entered manually will be imported',
            'type'     => 'checkbox',
            'validate' => 'onoff',
            'default'  => 'on',
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
