<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: import_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_import_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Import Item Sales
    $cnt = 0;

    if (isset($_post['item_payments']) && $_post['item_payments'] == 'on') {
        $tb1 = jrCore_db_table_name('jrFoxyCart', 'sale');
        $tb2 = jrCore_db_table_name('jrFoxyCart', 'purchase');
        $req = "SELECT * FROM {$tb1} s LEFT JOIN {$tb2} p ON p.purchase_id = s.sale_purchase_id ORDER BY s.sale_id ASC";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt)) {
            jrCore_form_modal_notice('update', "checking " . jrCore_number_format(count($_rt)) . " payment transactions");
            foreach ($_rt as $p) {
                if (isset($p['purchase_module'])) {

                    // Make sure we have not already imported this transaction
                    $tbl = jrCore_db_table_name('jrPayment', 'register');
                    $req = "SELECT * FROM {$tbl} WHERE r_gateway_id = '" . jrCore_db_escape($p['sale_txn_id']) . "' LIMIT 1";
                    $_ex = jrCore_db_query($req, 'SINGLE');
                    if ($_ex && is_array($_ex)) {
                        // Already imported
                        continue;
                    }

                    // Get the RAW transaction if we can
                    $_tx = jrCore_db_get_item_by_key('jrFoxyCart', 'txn_id', $p['sale_txn_id'], true);
                    $_tr = array(
                        'txn_id'       => $p['sale_txn_id'],
                        'txn_status'   => 'active',
                        'txn_date'     => $p['sale_time'],
                        'txn_type'     => 'payment',
                        'txn_plugin'   => (strpos($p['sale_txn_id'], '_')) ? 'stripe' : 'foxycart',
                        'txn_currency' => $_conf['jrFoxyCart_store_currency'],
                        'txn_total'    => jrPayment_price_to_cents($p['sale_gross']),
                        'txn_shipping' => jrPayment_price_to_cents($p['sale_shipping']),
                        'txn_user_id'  => $p['sale_buyer_user_id']
                    );
                    if (is_array($_tx)) {
                        $_tr['txn_raw'] = json_encode($_tx);
                    }
                    $_cr = array(
                        '_created'    => $p['sale_time'],
                        '_updated'    => $p['sale_time'],
                        '_profile_id' => 0,
                        '_user_id'    => 0
                    );
                    if ($tid = jrPayment_create_transaction($_tr, $_cr)) {
                        $_it = array();
                        if (isset($p['purchase_data']) && strlen($p['purchase_data']) > 0) {
                            $_it = json_decode($p['purchase_data'], true);
                        }
                        $_fl = array(
                            'r_txn_id'            => $tid,
                            'r_plugin'            => (strpos($p['sale_txn_id'], '_')) ? 'stripe' : 'foxycart',
                            'r_currency'          => $_conf['jrFoxyCart_store_currency'],
                            'r_gateway_id'        => $p['sale_txn_id'],
                            'r_created'           => $p['sale_time'],
                            'r_purchase_user_id'  => (int) $p['sale_buyer_user_id'],
                            'r_seller_profile_id' => (int) $p['sale_seller_profile_id'],
                            'r_module'            => $p['purchase_module'],
                            'r_item_id'           => $p['purchase_item_id'],
                            'r_field'             => $p['purchase_field'],
                            'r_quantity'          => 1,
                            'r_amount'            => jrPayment_price_to_cents($p['sale_gross']),
                            'r_shipping'          => jrPayment_price_to_cents($p['sale_shipping']),
                            'r_fee'               => 0,
                            'r_item_data'         => jrCore_db_escape(json_encode($_it)),
                            'r_note'              => '',
                            'r_tag'               => ''
                        );
                        $tbl = jrCore_db_table_name('jrPayment', 'register');
                        $req = "INSERT INTO {$tbl} (" . implode(',', array_keys($_fl)) . ") VALUES ('" . implode("','", $_fl) . "')";
                        $rid = jrCore_db_query($req, 'INSERT_ID');
                        if ($rid && $rid > 0) {
                            $cnt++;
                            if ($_fl['r_seller_profile_id'] > 0) {
                                // We've successfully sold a profile item - make sure it is added to the vault
                                if (!jrPayment_add_register_item_to_vault($_fl['r_module'], $_fl['r_item_id'], $_fl['r_field'], $_it)) {
                                    jrCore_logger('CRI', "Payments: unable to copy purchased media file to system vault: {$_it['_profile_id']}/{$_fl['r_module']}/{$_fl['r_item_id']}/{$_fl['r_field']}", $_it);
                                }
                                if ($p['sale_payed_out'] == 1) {
                                    $tbl = jrCore_db_table_name('jrPayment', 'register');
                                    $req = "UPDATE {$tbl} SET r_payed_out_time = '{$p['sale_time']}' WHERE r_id = {$rid}";
                                    jrCore_db_query($req);
                                }
                            }
                        }
                    }
                }
                if ($cnt > 0 && ($cnt % 50) === 0) {
                    jrCore_form_modal_notice('update', "imported transactions: {$cnt}");
                }
            }
        }
    }

    // Import Subscription Payments
    if (isset($_post['sub_payments']) && $_post['sub_payments'] == 'on') {
        if (jrCore_module_is_active('jrSubscribe')) {
            $tbl = jrCore_db_table_name('jrFoxyCart', 'purchase');
            $req = "SELECT * FROM {$tbl} WHERE purchase_module = 'jrFoxyCart' AND purchase_field = '' ORDER BY purchase_id ASC";
            $_rt = jrCore_db_query($req, 'NUMERIC');
            if ($_rt && is_array($_rt)) {

                $_ps = array();

                jrCore_form_modal_notice('update', "checking " . jrCore_number_format(count($_rt)) . " subscription payment transactions");
                foreach ($_rt as $p) {

                    // Make sure we have not already imported this transaction
                    $tbl = jrCore_db_table_name('jrPayment', 'register');
                    $req = "SELECT * FROM {$tbl} WHERE r_gateway_id = '" . jrCore_db_escape($p['purchase_txn_id']) . "' LIMIT 1";
                    $_ex = jrCore_db_query($req, 'SINGLE');
                    if ($_ex && is_array($_ex)) {
                        // Already imported
                        continue;
                    }

                    // Get the RAW transaction if we can
                    if ($_tx = jrCore_db_get_item_by_key('jrFoxyCart', 'txn_id', $p['purchase_txn_id'], true)) {
                        $_tr = array(
                            'txn_id'       => $p['purchase_txn_id'],
                            'txn_status'   => 'active',
                            'txn_date'     => $p['purchase_created'],
                            'txn_type'     => 'subscription',
                            'txn_plugin'   => 'foxycart',
                            'txn_currency' => $_conf['jrFoxyCart_store_currency'],
                            'txn_total'    => jrPayment_price_to_cents($p['purchase_price']),
                            'txn_shipping' => 0,
                            'txn_user_id'  => $p['purchase_user_id'],
                            'txn_raw'      => json_encode($_tx)
                        );
                        $_cr = array(
                            '_created'    => $p['purchase_created'],
                            '_updated'    => $p['purchase_created'],
                            '_profile_id' => 0,
                            '_user_id'    => 0
                        );
                        if ($tid = jrPayment_create_transaction($_tr, $_cr)) {

                            if ($_dt = json_decode($p['purchase_data'], true)) {
                                $_pl = false;
                                $qid = (int) $_dt['product_quota_id'];
                                if ($qid > 0) {
                                    if (!isset($_ps[$qid])) {
                                        if ($_pl = jrCore_db_get_item_by_key('jrSubscribe', 'sub_import_quota_id', $qid, true)) {
                                            $_ps[$qid] = $_pl;
                                        }
                                        else {
                                            $_ps[$qid] = 1;
                                            $_pl       = false;
                                        }
                                    }
                                    else {
                                        if (is_array($_ps[$qid])) {
                                            $_pl = $_ps[$qid];
                                        }
                                    }
                                }
                                $sub = '';
                                parse_str(parse_url($_dt['sub_token_url'], PHP_URL_QUERY), $_vars);
                                if ($_vars && isset($_vars['sub_token'])) {
                                    $sub = $_vars['sub_token'];
                                }
                                $_rd = array();
                                if (is_array($_pl)) {
                                    $_rd = $_pl;
                                }
                                if ($_us = jrCore_db_get_item('jrUser', $p['purchase_user_id'])) {
                                    $_rd = array_merge($_rd, $_us);
                                }
                                $_fl = array(
                                    'r_txn_id'            => $tid,
                                    'r_plugin'            => 'foxycart',
                                    'r_currency'          => $_conf['jrFoxyCart_store_currency'],
                                    'r_gateway_id'        => $p['purchase_txn_id'],
                                    'r_created'           => $p['purchase_created'],
                                    'r_purchase_user_id'  => (int) $p['purchase_user_id'],
                                    'r_seller_profile_id' => 0,
                                    'r_module'            => 'jrSubscribe',
                                    'r_item_id'           => (!empty($_pl['_item_id'])) ? $_pl['_item_id'] : 0,
                                    'r_field'             => 'sub_file',
                                    'r_quantity'          => 1,
                                    'r_amount'            => jrPayment_price_to_cents($p['purchase_price']),
                                    'r_shipping'          => 0,
                                    'r_fee'               => 0,
                                    'r_item_data'         => jrCore_db_escape(json_encode($_rd)),
                                    'r_note'              => '',
                                    'r_tag'               => $sub
                                );
                                $tbl = jrCore_db_table_name('jrPayment', 'register');
                                $req = "INSERT INTO {$tbl} (" . implode(',', array_keys($_fl)) . ") VALUES ('" . implode("','", $_fl) . "')";
                                $rid = jrCore_db_query($req, 'INSERT_ID');
                                if ($rid && $rid > 0) {
                                    $cnt++;
                                }
                            }
                        }
                        if ($cnt > 0 && ($cnt % 50) === 0) {
                            jrCore_form_modal_notice('update', "imported subscription transactions: {$cnt}");
                        }
                    }
                }
            }
        }
    }

    // Import Ledger Payments
    if (isset($_post['ledger_payments']) && $_post['ledger_payments'] == 'on') {
        $tbl = jrCore_db_table_name('jrFoxyCart', 'ledger');
        $req = "SELECT * FROM {$tbl} ORDER BY record_id ASC";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt)) {

            jrCore_form_modal_notice('update', "checking " . jrCore_number_format(count($_rt)) . " manual ledger transactions");
            foreach ($_rt as $p) {

                // Make sure we have not already imported this transaction
                $tbl = jrCore_db_table_name('jrPayment', 'register');
                $req = "SELECT * FROM {$tbl} WHERE r_gateway_id = '" . jrCore_db_escape($p['record_transaction_id']) . "' LIMIT 1";
                $_ex = jrCore_db_query($req, 'SINGLE');
                if ($_ex && is_array($_ex)) {
                    // Already imported
                    continue;
                }

                // If we got an email address, see if we can link it up to a user_id
                $_tx = array(
                    'txn_user_email' => $p['record_email'],
                    'txn_id'         => $p['record_transaction_id'],
                    'txn_total'      => jrPayment_price_to_cents($p['record_income']),
                    'txn_expense'    => jrPayment_price_to_cents($p['record_expense']),
                    'txn_date'       => $p['record_time'],
                    'txn_category'   => jrCore_str_to_lower($p['record_category']),
                    'txn_note'       => $p['record_details']
                );

                if (strpos($p['record_email'], '@')) {
                    if ($_us = jrCore_db_get_item_by_key('jrUser', 'user_email', $p['record_email'], true)) {
                        $_tx['txn_user_id'] = (int) $_us['_user_id'];
                    }
                }
                if (!isset($_tx['txn_user_id'])) {
                    $_tx['txn_user_id'] = 0;
                }
                $_tx['txn_tax']      = 0;
                $_tx['txn_shipping'] = 0;
                $_tx['txn_type']     = 'payment';
                $_tx['txn_currency'] = jrPayment_run_plugin_function('get_currency_code');

                $_cr = array(
                    '_profile_id' => 0,
                    '_user_id'    => 0,
                    '_created'    => $p['record_time'],
                    '_updated'    => $p['record_time']
                );

                if (!$tid = jrCore_db_create_item('jrPayment', $_tx, $_cr)) {
                    // We had an error creating the item in the datastore
                    continue;
                }

                $_tx['_item_id']      = $tid; // use transaction DS id
                $_tx['_profile_id']   = 0;    // No profile is seller
                $_tx['cart_amount']   = $_tx['txn_total'];
                $_tx['cart_expense']  = $_tx['txn_expense'];
                $_tx['cart_shipping'] = 0;
                $_tx['cart_quantity'] = 1;
                $_tx['cart_module']   = 'jrPayment';
                $_tx['cart_field']    = 'transaction';

                // Create register entry
                jrPayment_record_sale_in_register($tid, $_tx['txn_id'], $_tx['txn_user_id'], $_tx, $_tx['txn_category'], 0, 0, $p['record_time']);
                $cnt++;

                if ($cnt > 0 && ($cnt % 50) === 0) {
                    jrCore_form_modal_notice('update', "imported manual ledger transactions: {$cnt}");
                }
            }
        }
    }

    jrCore_form_modal_notice('complete', "successfully imported " . jrCore_number_format($cnt) . " valid purchase transactions from FoxyCart eCommerce module");
    jrCore_exit();
}
