<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: modify_register_entry_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_modify_register_entry_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    $_tx = array();

    // If we got an email address, see if we can link it up to a user_id
    if (!empty($_post['txn_user_email']) && strpos($_post['txn_user_email'], '@')) {
        if ($_us = jrCore_db_get_item_by_key('jrUser', 'user_email', $_post['txn_user_email'], true)) {
            $_tx['txn_user_id'] = (int) $_us['_user_id'];
        }
    }
    if (empty($_tx['txn_user_id'])) {
        $_tx['txn_user_id'] = 0;
    }
    $_tx['txn_id']       = jrCore_db_escape($_post['txn_id']);
    $_tx['txn_total']    = jrPayment_price_to_cents($_post['txn_total']);
    $_tx['txn_expense']  = jrPayment_price_to_cents($_post['txn_expense']);
    $_tx['txn_tax']      = 0;
    $_tx['txn_shipping'] = 0;
    $_tx['txn_date']     = $_post['txn_date'];
    $_tx['txn_type']     = 'payment';
    $_tx['txn_category'] = $_post['txn_category'];
    $_tx['txn_currency'] = jrPayment_run_plugin_function('get_currency_code');

    jrCore_db_update_item('jrPayment', $_post['item_id'], $_tx);

    // Update values in transaction
    $rid = (int) $_post['register_id'];
    $uid = (int) $_tx['txn_user_id'];
    $cat = jrCore_db_escape($_post['txn_category']);
    $dat = (int) $_post['txn_date'];
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    $req = "UPDATE {$tbl} SET r_created = {$dat}, r_purchase_user_id = {$uid}, r_amount = {$_tx['txn_total']}, r_expense = {$_tx['txn_expense']}, r_gateway_id = '{$_tx['txn_id']}', r_tag = '{$cat}' WHERE r_id = {$rid}";
    jrCore_db_query($req);
    jrCore_form_delete_session();
    jrCore_set_form_notice('success', "The payment transaction was successfully updated");
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/txn_detail/{$_post['item_id']}");
}
