<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payout
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_payout($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_banner('Profile Payout', '<small>&starf; includes tax<br>&star; includes shipping</small>');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'select';
    $dat[1]['width'] = '4%';
    $dat[2]['title'] = 'profile';
    $dat[2]['width'] = '21%';
    $dat[3]['title'] = 'payout email address';
    $dat[3]['width'] = '33%';
    $dat[4]['title'] = 'sales';
    $dat[4]['width'] = '12%';
    $dat[5]['title'] = 'system fee';
    $dat[5]['width'] = '12%';
    $dat[6]['title'] = 'payout';
    $dat[6]['width'] = '18%';
    jrCore_page_table_header($dat);

    // First up - get all the profiles we are going to payout and the
    // quota that their profile belongs to
    $old = ($_conf['jrPayment_payout_clears'] * 86400);
    $tbl = jrCore_db_table_name('jrPayment', 'register');

    $_pi = array();
    $req = "SELECT r_seller_profile_id AS pid FROM {$tbl} WHERE r_payed_out_time = 0 AND r_created < (UNIX_TIMESTAMP() - {$old}) AND r_seller_profile_id > 0 GROUP BY r_seller_profile_id";
    $_rt = jrCore_db_query($req, 'pid');
    if ($_rt && is_array($_rt)) {
        $_sc = array(
            'search'        => array(
                '_profile_id in ' . implode(',', array_keys($_rt))
            ),
            'return_keys'   => array('_profile_id', 'profile_quota_id'),
            'skip_triggers' => true,
            'privacy_check' => false,
            'limit'         => count($_rt)
        );
        $_sc = jrCore_db_search_items('jrProfile', $_sc);
        if ($_sc && is_array($_sc) && isset($_sc['_items'])) {
            foreach ($_sc['_items'] as $p) {
                $pid = (int) $p['_profile_id'];
                $qid = (int) $p['profile_quota_id'];
                if (!isset($_pi[$qid])) {
                    $_pi[$qid] = array();
                }
                $_pi[$qid][] = $pid;
            }
        }
    }

    $done = false;
    if (count($_pi) > 0) {

        // We have our profile and Quota info - get tax and shipping options from the quota
        $_id = array();
        $_us = array();
        $_ui = array();
        $_in = array();
        $_fe = array();
        $_qo = array();
        $_qi = array();
        foreach ($_pi as $quota_id => $_pids) {

            // Get payments for payout
            $tax = 'off';
            $shp = 'off';
            $_qt = jrProfile_get_quota($quota_id);
            // We are including BOTH shipping and tax in this payout
            if ($_qt['quota_jrPayment_include_tax'] == 'on' && $_qt['quota_jrPayment_include_shipping'] == 'on') {
                $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping + r_tax) - r_refunded_amount) AS r_amount, ((r_amount + r_shipping + r_tax) - r_fee - r_refunded_amount) AS r_income, r_fee FROM {$tbl}
                         WHERE r_payed_out_time = 0 AND r_created < (UNIX_TIMESTAMP() - {$old}) AND r_seller_profile_id IN(" . implode(',', $_pids) . ')';
                $tax = 'on';
                $shp = 'on';
            }
            // We are including ONLY tax in this payout
            elseif ($_qt['quota_jrPayment_include_tax'] == 'on') {
                $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_tax) - r_refunded_amount) AS r_amount, ((r_amount + r_tax) - r_fee - r_refunded_amount) AS r_income, r_fee FROM {$tbl}
                         WHERE r_payed_out_time = 0 AND r_created < (UNIX_TIMESTAMP() - {$old}) AND r_seller_profile_id IN(" . implode(',', $_pids) . ')';
                $tax = 'on';
            }
            // We are including ONLY shipping in this payout
            elseif ($_qt['quota_jrPayment_include_shipping'] == 'on') {
                $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping) - r_refunded_amount) AS r_amount, ((r_amount + r_shipping) - r_fee - r_refunded_amount) AS r_income, r_fee FROM {$tbl}
                         WHERE r_payed_out_time = 0 AND r_created < (UNIX_TIMESTAMP() - {$old}) AND r_seller_profile_id IN(" . implode(',', $_pids) . ')';
                $shp = 'on';
            }
            // We are not including Tax OR Shipping
            else {
                $req = "SELECT r_id, r_seller_profile_id, (r_amount - r_refunded_amount) AS r_amount, (r_amount - r_fee - r_refunded_amount) AS r_income, r_fee FROM {$tbl}
                         WHERE r_payed_out_time = 0 AND r_created < (UNIX_TIMESTAMP() - {$old}) AND r_seller_profile_id IN(" . implode(',', $_pids) . ')';
            }
            $_rt = jrCore_db_query($req, 'r_id');
            if ($_rt && is_array($_rt)) {
                foreach ($_rt as $rid => $_r) {
                    $pid = (int) $_r['r_seller_profile_id'];
                    if (!isset($_ui[$pid])) {
                        $_ui[$pid] = 0;
                        $_fe[$pid] = 0;
                    }
                    $_in[$pid] += $_r['r_amount'];
                    $_ui[$pid] += $_r['r_income'];
                    $_fe[$pid] += $_r['r_fee'];
                    $_qi[$pid] = $quota_id;
                    $_id[]     = $rid;
                }
            }
            $_qo[$quota_id] = array(
                'tax' => $tax,
                'shp' => $shp
            );
        }
        arsort($_ui, SORT_NUMERIC);

        // Save our payout key
        $md5 = md5(microtime() . mt_rand());
        $tbl = jrCore_db_table_name('jrPayment', 'payout');

        // If we get an "r" value on the URL it means we have canceled a payout
        // and need to reset the existing form session
        if (!empty($_post['r']) && jrCore_checktype($_post['r'], 'number_nz')) {
            jrCore_form_delete_session();
            $req = "DELETE FROM {$tbl} WHERE payout_completed = 0";
            jrCore_db_query($req);
        }

        $_op = array(
            'pids' => $_pi,
            'opts' => $_qo
        );
        $opt = jrCore_db_escape(json_encode($_op));
        // Note: we don't store payout_profile_id's here - that will be filled in below after saving
        $req = "INSERT INTO {$tbl} (payout_key, payout_time, payout_profile_ids, payout_ids, payout_refunds, payout_options) VALUE ('{$md5}', UNIX_TIMESTAMP(), '', '" . implode(',', $_id) . "', '', '{$opt}')";
        jrCore_db_query($req);

        // Form init
        $_tmp = array(
            'submit_value'     => 'payout selected profiles',
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
            'form_ajax_submit' => false
        );
        jrCore_form_create($_tmp);

        // Unique Payout Code
        // NOTE: We save this as part of the session since if we pass it in
        // as a hidden form element it does NOT change based on the form session
        $_SESSION['p_code'] = $md5;

        if (count($_ui) > 0) {
            $_pr = array(
                'search'         => array(
                    '_item_id in ' . implode(',', array_keys($_ui))
                ),
                'return_keys'    => array('_profile_id', 'profile_url', 'profile_jrPayment_payout_email', 'profile_jrPayment_refund_adjust'),
                'skip_triggers'  => true,
                'privacy_check'  => false,
                'ignore_pending' => true,
                'limit'          => count($_ui)
            );
            $_pr = jrCore_db_search_items('jrProfile', $_pr);
            if ($_pr && is_array($_pr) && isset($_pr['_items'])) {
                foreach ($_pr['_items'] as $_u) {
                    $uid       = (int) $_u['_profile_id'];
                    $_us[$uid] = $_u;
                }
            }
            $_rf = array();
            $_ra = array();
            $url = jrCore_get_module_url('jrProfile');
            foreach ($_ui as $pid => $amount) {
                if (isset($_us[$pid]['profile_jrPayment_refund_adjust']) && $_us[$pid]['profile_jrPayment_refund_adjust'] > 0) {
                    // This profile's payout is going to be adjust since we had a refund on one of their items
                    $_rf[$pid] = $amount;
                    $_ra[$pid] = (int) $_us[$pid]['profile_jrPayment_refund_adjust'];
                    continue;
                }
                if ($amount < 0) {
                    continue;
                }
                $dat = array();
                // We have to have an email address to payout
                if (!empty($_us[$pid]['profile_jrPayment_payout_email'])) {
                    if ($amount > 1000) {
                        $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '" checked="checked">';
                    }
                    else {
                        $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '">';
                    }
                    $dat[3]['title'] = $_us[$pid]['profile_jrPayment_payout_email'];
                    $dat[3]['class'] = 'center';
                }
                else {
                    $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '" disabled="disabled">';
                    $dat[3]['title'] = 'no payout email address';
                    $dat[3]['class'] = 'error center';
                }
                $dat[1]['class'] = 'center';
                $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$url}/settings/profile_id={$pid}\">@" . $_us[$pid]['profile_url'] . '</a>';
                $dat[2]['class'] = 'center';
                $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_in[$pid]);
                $dat[4]['class'] = 'center';
                $dat[5]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_fe[$pid]);
                $dat[5]['class'] = 'center';
                $dat[6]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($amount);
                if (isset($_qi[$pid])) {
                    $qid = (int) $_qi[$pid];
                    if (isset($_qo[$qid])) {
                        if ($_qo[$qid]['tax'] == 'on' && $_qo[$qid]['shp'] == 'on') {
                            $dat[6]['title'] .= ' <sup><small>&starf;&star;</small></sup>';
                        }
                        elseif ($_qo[$qid]['tax'] == 'on') {
                            $dat[6]['title'] .= ' <sup><small>&starf;</small></sup>';
                        }
                        elseif ($_qo[$qid]['shp'] == 'on') {
                            $dat[6]['title'] .= ' <sup><small>&star;</small></sup>';
                        }
                    }
                }
                $dat[6]['class'] = 'center';
                jrCore_page_table_row($dat);
                $done = true;
            }

            if (count($_rf) > 0) {

                // Save refund info for this payout key
                $tbl = jrCore_db_table_name('jrPayment', 'payout');
                $req = "UPDATE {$tbl} SET payout_refunds = '" . json_encode($_ra) . "' WHERE payout_key = '{$md5}' LIMIT 1";
                jrCore_db_query($req);

                // We have profiles that need to have their payout adjusted
                foreach ($_rf as $pid => $amount) {
                    if ($amount < 0) {
                        continue;
                    }
                    $dat = array();
                    // We have to have an email address to payout
                    if (isset($_us[$pid]['profile_jrPayment_payout_email'])) {
                        if ($amount > 1000) {
                            $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '" checked="checked">';
                        }
                        else {
                            $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '">';
                        }
                        $dat[3]['title'] = $_us[$pid]['profile_jrPayment_payout_email'];
                        $dat[3]['class'] = 'center';
                    }
                    else {
                        $dat[1]['title'] = '<input name="profile_id[' . $pid . ']" type="checkbox" value="' . $amount . '" disabled="disabled">';
                        $dat[3]['title'] = 'no payout email address';
                        $dat[3]['class'] = 'error center';
                    }
                    $dat[1]['class'] = 'center';
                    $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_us[$pid]['profile_url']}\">@" . $_us[$pid]['profile_url'] . '</a>';
                    $dat[2]['class'] = 'center';
                    $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_in[$pid]);
                    $dat[4]['class'] = 'center';
                    $dat[5]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_fe[$pid]);
                    $dat[5]['class'] = 'center';

                    $adjust = $_us[$pid]['profile_jrPayment_refund_adjust'];
                    if ($amount > $adjust) {
                        $dat[6]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($amount - $adjust);
                    }
                    else {
                        // This profile will NOT be payed out
                        $dat[6]['title'] = jrPayment_get_currency_code() . '0';
                    }
                    if (isset($_qi[$pid])) {
                        $qid = (int) $_qi[$pid];
                        if (isset($_qo[$qid])) {
                            if ($_qo[$qid]['tax'] == 'on' && $_qo[$qid]['shp'] == 'on') {
                                $dat[6]['title'] .= ' <sup><small>&starf;&star;</small></sup>';
                            }
                            elseif ($_qo[$qid]['tax'] == 'on') {
                                $dat[6]['title'] .= ' <sup><small>&starf;</small></sup>';
                            }
                            elseif ($_qo[$qid]['shp'] == 'on') {
                                $dat[6]['title'] .= ' <sup><small>&star;</small></sup>';
                            }
                        }
                    }
                    $adjurl = "<a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/payments/profile_id={$pid}/refunded=1\" target=\"_blank\"><u>refunds</u></a>";
                    if ($amount > $adjust) {
                        $dat[6]['title'] .= '<br><small>-' . jrPayment_get_currency_code() . jrPayment_currency_format($adjust) . " for {$adjurl}</small>";
                    }
                    else {
                        // This profile will NOT be payed out
                        $dat[6]['title'] .= '<br><small>-' . jrPayment_get_currency_code() . jrPayment_currency_format($amount) . " for {$adjurl}</small>";
                    }
                    $dat[6]['class'] = 'center';
                    jrCore_page_table_row($dat);
                    $done = true;
                }
            }
        }

    }
    if (!$done) {
        $dat             = array();
        $dat[1]['title'] = 'There are no profiles with pending payouts';
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_display();
}
