<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payout_complete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_payout_complete($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // We must have a valid payout code
    if (!isset($_SESSION['p_code']) || !jrCore_checktype($_SESSION['p_code'], 'md5')) {
        jrCore_set_form_notice('error', 'Invalid payout code received - please try again');
        jrCore_location('referrer');
    }

    $tbl = jrCore_db_table_name('jrPayment', 'payout');
    $req = "SELECT * FROM {$tbl} WHERE payout_key = '" . jrCore_db_escape($_SESSION['p_code']) . "'";
    $_id = jrCore_db_query($req, 'SINGLE');
    if (!$_id || !is_array($_id)) {
        jrCore_set_form_notice('error', 'Invalid payout code received - no ids found in DB');
        jrCore_location('referrer');
    }

    $tbl = jrCore_db_table_name('jrPayment', 'register');
    $req = "UPDATE {$tbl} SET r_payed_out_time = UNIX_TIMESTAMP() WHERE r_id IN({$_id['payout_ids']}) AND r_seller_profile_id IN({$_id['payout_profile_ids']})";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt && $cnt > 0) {

        $_pd = explode(',', $_id['payout_profile_ids']);
        if ($_pd && is_array($_pd)) {

            // Get our payout options
            $_op = json_decode($_id['payout_options'], true);
            if (!isset($_op['pids']) || !is_array($_op['pids'])) {
                jrCore_set_form_notice('error', 'Invalid payout options received');
                jrCore_location('referrer');
            }

            $_am = array();
            $tbl = jrCore_db_table_name('jrPayment', 'register');
            foreach ($_op['pids'] as $quota_id => $_pids) {

                $_opts = $_op['opts'][$quota_id];
                // We are including BOTH shipping and tax in this payout
                if ($_opts['tax'] == 'on' && $_opts['shp'] == 'on') {
                    $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping + r_tax) - r_fee - r_refunded_amount) AS r_amount FROM {$tbl}
                             WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
                }
                // We are including ONLY tax in this payout
                elseif ($_opts['tax'] == 'on') {
                    $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_tax) - r_fee - r_refunded_amount) AS r_amount FROM {$tbl}
                             WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
                }
                // We are including ONLY shipping in this payout
                elseif ($_opts['shp'] == 'on') {
                    $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping) - r_fee - r_refunded_amount) AS r_amount FROM {$tbl}
                             WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
                }
                // We are not including Tax OR Shipping
                else {
                    $req = "SELECT r_id, r_seller_profile_id, (r_amount - r_fee - r_refunded_amount) AS r_amount FROM {$tbl}
                             WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
                }
                $_rt = jrCore_db_query($req, 'r_id');
                if (!$_rt || !is_array($_rt)) {
                    // Something is wrong...
                    jrCore_set_form_notice('error', 'payout transactions listed in payout are not found in the DB');
                    jrCore_location('referrer');
                }
                $_pa = array();
                foreach ($_rt as $_r) {
                    $pid = (int) $_r['r_seller_profile_id'];
                    if (!isset($_pa[$pid])) {
                        $_pa[$pid] = 0;
                    }
                    $_am[$pid] += $_r['r_amount'];
                }
            }

            if (strlen($_id['payout_refunds']) > 0) {
                // We have some refunds to process
                if ($_rf = json_decode($_id['payout_refunds'], true)) {
                    foreach ($_rf as $pid => $amount) {
                        if (isset($_am[$pid])) {
                            if ($amount > $_am[$pid]) {
                                // This profile gets no payout
                                $_am[$pid] = 0;
                                // We did not use up all the refund adjustment - decrement
                                jrCore_db_decrement_key('jrProfile', $pid, 'profile_jrPayment_refund_adjust', $_am[$pid], 0);
                            }
                            else {
                                $_am[$pid] = ($_am[$pid] - $amount);
                                // We used ALL the refund adjustment - delete the key
                                jrCore_db_delete_item_key('jrProfile', $pid, 'profile_jrPayment_refund_adjust');
                            }
                        }
                    }
                }
            }

            // Get profile info for these profile ids
            $_pr = array();
            $_tm = jrCore_db_get_multiple_items('jrProfile', $_pd, array('_profile_id', 'profile_jrPayment_payout_email'));
            if ($_tm && is_array($_tm)) {
                foreach ($_tm as $_p) {
                    $pid       = (int) $_p['_profile_id'];
                    $_pr[$pid] = $_p;
                }
            }

            // Notify the profiles they have been paid
            foreach ($_pd as $pid) {
                $_rp = array(
                    'payout_email'  => $_pr[$pid]['profile_jrPayment_payout_email'],
                    'payout_amount' => jrPayment_currency_format($_am[$pid])
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrPayment', 'profile_payout', $_rp);
                jrCore_send_email($_pr[$pid]['profile_jrPayment_payout_email'], $sub, $msg);
                jrCore_logger('INF', "Payments: successfully payed out " . jrPayment_currency_format($_am[$pid]) . " to " . $_pr[$pid]['profile_jrPayment_payout_email']);
            }

            // Mark this payout code as done
            $tbl = jrCore_db_table_name('jrPayment', 'payout');
            $req = "UPDATE {$tbl} SET payout_completed = UNIX_TIMESTAMP() WHERE payout_key = '" . jrCore_db_escape($_SESSION['p_code']) . "'";
            jrCore_db_query($req);
            unset($_SESSION['p_code']);

            jrCore_logger('INF', "Payments: marked {$cnt} transactions as payed out to profiles");

            jrCore_page_include_admin_menu();
            jrCore_page_admin_tabs('jrPayment');
            jrCore_page_banner('Payout Complete');
            jrCore_set_form_notice('success', 'The selected profile payouts have been completed.');
            jrCore_get_form_notice();
            jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout", 'continue');
            jrCore_page_display();
        }
    }
    else {
        jrCore_form_delete_session();
        jrCore_set_form_notice('error', 'Invalid payout key - please try again');
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout");
    }
}
