<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payout_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_payout_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // We must have at least 1 profile to payout
    if (!isset($_post['profile_id']) || !is_array($_post['profile_id'])) {
        jrCore_set_form_notice('error', 'You must choose at least one profile to payout');
        jrCore_location('referrer');
    }

    // We must have a valid payout code
    if (!isset($_SESSION['p_code']) || !jrCore_checktype($_SESSION['p_code'], 'md5')) {
        jrCore_set_form_notice('error', 'Invalid payout code received - please try again');
        jrCore_location('referrer');
    }

    $tbl = jrCore_db_table_name('jrPayment', 'payout');
    $req = "SELECT payout_ids FROM {$tbl} WHERE payout_key = '" . jrCore_db_escape($_SESSION['p_code']) . "'";
    $_id = jrCore_db_query($req, 'SINGLE');
    if (!$_id || !is_array($_id)) {
        jrCore_set_form_notice('error', 'Invalid payout code received - no ids found in DB');
        jrCore_location('referrer');
    }

    // Now we have the complete list of register ID's that are in this payout process
    // Save posted PIDs to the DB
    $_pd = array();
    foreach ($_post['profile_id'] as $id => $amount) {
        $_pd[] = (int) $id;
    }
    $req = "UPDATE {$tbl} SET payout_profile_ids = '" . implode(',', $_pd) . "' WHERE payout_key = '" . jrCore_db_escape($_SESSION['p_code']) . "'";
    jrCore_db_query($req);

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_banner('Payout Profiles');
    jrCore_get_form_notice();

    $note = "<div class=\"p10\" style=\"text-align:left\">
    <ul><li>You should be prompted to download the Payments CSV file - save to your computer.</li><br>
    <li> <a href=\"https://www.paypal.com\" target=\"_blank\"><u>Log in to PayPal</u></a> and go to Send Payment &raquo; Make a Mass Payment.</li>
    <li> Select the CSV file that was just download and upload it to PayPal in the Mass Pay form.</li>
    <li> Complete the Mass Pay process at PayPal.</li>
    <li> Click the &quot;Complete Payout&quot; button below when finished.</li><br>
    <li>You can redownload the CSV file by <a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout_csv/p_code={$_SESSION['p_code']}\"><u>Clicking Here.</u></a></li></ul>
    <iframe src=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout_csv/p_code={$_SESSION['p_code']}\" style=\"display:none;\"></iframe>";
    jrCore_set_form_notice('notice', $note, false);
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => 'complete payout',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout/r=" . mt_rand(11111, 99999),
        'form_ajax_submit' => false,
        'action'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/payout_complete"
    );
    jrCore_form_create($_tmp);

    // key
    $_tmp = array(
        'name'  => 'p_code',
        'type'  => 'hidden',
        'value' => $_SESSION['p_code']
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
