<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: plugin_config
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_plugin_config($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_include_admin_menu();
    jrCore_validate_location_url();
    if (empty($_post['_1']) || !jrPayment_is_valid_plugin($_post['_1'])) {
        jrCore_notice_page('error', 'invalid plugin');
    }
    // Get config as provided by plugin
    $plug = $_post['_1'];
    $func = "jrPayment_plugin_{$plug}_config";
    if (!function_exists($func)) {
        require_once APP_DIR . "/modules/jrPayment/plugins/{$plug}.php";
    }
    if (!function_exists($func)) {
        jrCore_notice_page('error', 'no plugin config found');
    }
    $_mta = jrPayment_get_plugin_meta_data($plug);

    // Config form
    $button = jrCore_page_button('admin', "{$plug} admin", "window.open('{$_mta['admin']}')");
    jrCore_page_banner("{$_mta['title']} config", $button);

    // Form init
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/plugin_browser",
        'values'       => jrPayment_get_plugin_config($plug)
    );
    jrCore_form_create($_tmp);

    // Plugin
    $_tmp = array(
        'name'     => 'plugin',
        'type'     => 'hidden',
        'validate' => 'printable',
        'value'    => $plug
    );
    jrCore_form_field_create($_tmp);

    // Brings in config form fields for plugin
    $func($_post);
    jrCore_page_display();
}
